/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.collect.Collections2;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.opendaylight.mdsal.binding.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;

public final class SerialVersionHelper {
    private static final Set<ConcreteType> IGNORED_INTERFACES = Set.of(BindingTypes.TYPE_OBJECT, BindingTypes.SCALAR_TYPE_OBJECT);
    private static final Comparator<TypeMemberBuilder<?>> SUID_MEMBER_COMPARATOR = Comparator.comparing(TypeMemberBuilder::getName);
    private static final Comparator<Type> SUID_NAME_COMPARATOR = Comparator.comparing(Type::getFullyQualifiedName);
    private static final ThreadLocal<MessageDigest> SHA1_MD = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to get a SHA digest provider", e);
        }
    });

    private SerialVersionHelper() {
    }

    public static long computeDefaultSUID(GeneratedTypeBuilderBase<?> to) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (DataOutputStream dout = new DataOutputStream(bout);){
            dout.writeUTF(to.getName());
            dout.writeInt(to.isAbstract() ? 3 : 7);
            for (Type type : SerialVersionHelper.sortedCollection(SUID_NAME_COMPARATOR, SerialVersionHelper.filteredImplementsTypes(to))) {
                dout.writeUTF(type.getFullyQualifiedName());
            }
            for (GeneratedPropertyBuilder generatedPropertyBuilder : SerialVersionHelper.sortedCollection(SUID_MEMBER_COMPARATOR, to.getProperties())) {
                dout.writeUTF(generatedPropertyBuilder.getName());
            }
            for (MethodSignatureBuilder methodSignatureBuilder : SerialVersionHelper.sortedCollection(SUID_MEMBER_COMPARATOR, to.getMethodDefinitions())) {
                if (methodSignatureBuilder.getAccessModifier().equals((Object)AccessModifier.PRIVATE)) continue;
                dout.writeUTF(methodSignatureBuilder.getName());
                dout.write(methodSignatureBuilder.getAccessModifier().ordinal());
            }
            dout.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to hash object " + to, e);
        }
        byte[] hashBytes = SHA1_MD.get().digest(bout.toByteArray());
        long hash = 0L;
        for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
            hash = hash << 8 | (long)(hashBytes[i] & 0xFF);
        }
        return hash;
    }

    private static Collection<Type> filteredImplementsTypes(GeneratedTypeBuilderBase<?> to) {
        return Collections2.filter((Collection)to.getImplementsTypes(), item -> !IGNORED_INTERFACES.contains(item));
    }

    private static <T> Iterable<T> sortedCollection(Comparator<? super T> comparator, Collection<T> input) {
        if (input.size() <= 1) {
            return input;
        }
        ArrayList<T> ret = new ArrayList<T>(input);
        ret.sort(comparator);
        return ret;
    }
}

