/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractTypeObjectGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.IdentityGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.Types;

abstract class TypeReference {
    TypeReference() {
    }

    static @NonNull TypeReference leafRef(@Nullable AbstractTypeObjectGenerator<?, ?> referencedGenerator) {
        return referencedGenerator == null ? UnresolvedLeafref.INSTANCE : new ResolvedLeafref(referencedGenerator);
    }

    static @NonNull TypeReference identityRef(List<IdentityGenerator> referencedGenerators) {
        return new Identityref(referencedGenerators);
    }

    abstract @NonNull Type methodReturnType(@NonNull TypeBuilderFactory var1);

    private static final class UnresolvedLeafref
    extends Leafref {
        static final @NonNull UnresolvedLeafref INSTANCE = new UnresolvedLeafref();

        private UnresolvedLeafref() {
        }

        @Override
        Type methodReturnType(TypeBuilderFactory builderFactory) {
            return Types.objectType();
        }
    }

    static final class ResolvedLeafref
    extends Leafref {
        private final AbstractTypeObjectGenerator<?, ?> referencedGenerator;

        private ResolvedLeafref(AbstractTypeObjectGenerator<?, ?> referencedGenerator) {
            this.referencedGenerator = Objects.requireNonNull(referencedGenerator);
        }

        @Override
        Type methodReturnType(TypeBuilderFactory builderFactory) {
            return this.referencedGenerator.methodReturnElementType(builderFactory);
        }
    }

    static abstract class Leafref
    extends TypeReference {
        private Leafref() {
        }
    }

    private static final class Identityref
    extends TypeReference {
        private final List<IdentityGenerator> referencedGenerators;
        private ParameterizedType returnType;

        Identityref(List<IdentityGenerator> referencedGenerators) {
            this.referencedGenerators = Objects.requireNonNull(referencedGenerators);
        }

        @Override
        Type methodReturnType(TypeBuilderFactory builderFactory) {
            if (this.returnType == null) {
                List referencedTypes = this.referencedGenerators.stream().map(gen -> gen.getGeneratedType(builderFactory)).collect(Collectors.toUnmodifiableList());
                this.returnType = Types.classType((Type)Types.wildcardTypeFor((JavaTypeName)((JavaTypeName)((GeneratedType)referencedTypes.get(0)).getIdentifier())));
            }
            return this.returnType;
        }
    }
}

