/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractTypeObjectGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.StatementNamespace;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeReference;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultTypedefRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.runtime.api.TypedefRuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class TypedefGenerator
extends AbstractTypeObjectGenerator<TypedefEffectiveStatement, TypedefRuntimeType> {
    private List<AbstractTypeObjectGenerator<?, ?>> derivedGenerators = null;

    TypedefGenerator(TypedefEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.TYPEDEF;
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterTypedef((QName)((TypedefEffectiveStatement)this.statement()).argument());
    }

    void addDerivedGenerator(AbstractTypeObjectGenerator<?, ?> derivedGenerator) {
        if (this.derivedGenerators == null) {
            this.derivedGenerators = new ArrayList(4);
        }
        this.derivedGenerators.add(Objects.requireNonNull(derivedGenerator));
    }

    @Override
    void bindDerivedGenerators(TypeReference reference) {
        if (this.derivedGenerators != null) {
            for (AbstractTypeObjectGenerator<?, ?> derived : this.derivedGenerators) {
                derived.bindTypeDefinition(reference);
            }
        }
        this.derivedGenerators = List.of();
    }

    @Override
    ClassPlacement classPlacementImpl() {
        return ClassPlacement.TOP_LEVEL;
    }

    @Override
    TypeDefinition<?> extractTypeDefinition() {
        return ((TypedefEffectiveStatement)this.statement()).getTypeDefinition();
    }

    @Override
    GeneratedTransferObject createDerivedType(TypeBuilderFactory builderFactory, GeneratedTransferObject baseType) {
        GeneratedTOBuilder builder = builderFactory.newGeneratedTOBuilder(this.typeName());
        builder.setTypedef(true);
        builder.setExtendsType(baseType);
        builder.setIsUnion(baseType.isUnionType());
        builder.setRestrictions(this.computeRestrictions());
        TypeDefinition typedef = ((TypedefEffectiveStatement)this.statement()).getTypeDefinition();
        TypedefGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)typedef, (AnnotableTypeBuilder)builder);
        TypedefGenerator.addStringRegExAsConstant(builder, TypedefGenerator.resolveRegExpressions(typedef));
        TypedefGenerator.addUnits(builder, typedef);
        TypedefGenerator.makeSerializable(builder);
        return builder.build();
    }

    @Override
    TypedefRuntimeType createExternalRuntimeType(Type type) {
        Verify.verify((boolean)(type instanceof GeneratedType), (String)"Unexpected type %s", (Object)type);
        return new DefaultTypedefRuntimeType((GeneratedType)type, (TypedefEffectiveStatement)this.statement());
    }

    @Override
    TypedefRuntimeType createInternalRuntimeType(AugmentResolver resolver, TypedefEffectiveStatement statement, Type type) {
        throw new UnsupportedOperationException("Should never be called");
    }

    @Override
    void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }
}

