/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.rt;

import com.google.common.base.Functions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.impl.rt.AbstractRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.GeneratedRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;

abstract class AbstractCompositeRuntimeType<S extends EffectiveStatement<?, ?>>
extends AbstractRuntimeType<S, GeneratedType>
implements CompositeRuntimeType {
    private static final RuntimeType[] EMPTY = new RuntimeType[0];
    private final ImmutableMap<JavaTypeName, GeneratedRuntimeType> byClass;
    private final Object bySchemaTree;

    @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="https://github.com/spotbugs/spotbugs/issues/1985")
    AbstractCompositeRuntimeType(GeneratedType bindingType, S statement, List<RuntimeType> children) {
        super(bindingType, statement);
        this.byClass = (ImmutableMap)children.stream().filter(GeneratedRuntimeType.class::isInstance).map(GeneratedRuntimeType.class::cast).collect(ImmutableMap.toImmutableMap(GeneratedRuntimeType::getIdentifier, (Function)Functions.identity()));
        RuntimeType[] tmp = (RuntimeType[])children.stream().filter(child -> child.statement() instanceof SchemaTreeEffectiveStatement).toArray(RuntimeType[]::new);
        switch (tmp.length) {
            case 0: {
                this.bySchemaTree = EMPTY;
                break;
            }
            case 1: {
                this.bySchemaTree = tmp[0];
                break;
            }
            default: {
                Arrays.sort(tmp, (o1, o2) -> {
                    int cmp = AbstractCompositeRuntimeType.extractQName(o1).compareTo(AbstractCompositeRuntimeType.extractQName(o2));
                    Verify.verify((cmp != 0 ? 1 : 0) != 0, (String)"Type %s conflicts with %s on schema tree", (Object)o1, (Object)o2);
                    return cmp;
                });
                this.bySchemaTree = tmp;
            }
        }
    }

    public final RuntimeType schemaTreeChild(QName qname) {
        if (this.bySchemaTree instanceof RuntimeType) {
            RuntimeType tmp = (RuntimeType)this.bySchemaTree;
            return qname.equals(tmp.statement().argument()) ? tmp : null;
        }
        RuntimeType[] tmp = (RuntimeType[])this.bySchemaTree;
        int offset = Arrays.binarySearch(tmp, null, (o1, o2) -> {
            Verify.verify((o2 == null ? 1 : 0) != 0, (String)"Unexpected key %s", (Object)o2);
            return AbstractCompositeRuntimeType.extractQName(o1).compareTo(qname);
        });
        return offset < 0 ? null : tmp[offset];
    }

    public final GeneratedRuntimeType bindingChild(JavaTypeName typeName) {
        return (GeneratedRuntimeType)this.byClass.get((Object)Objects.requireNonNull(typeName));
    }

    final <T extends RuntimeType> @NonNull List<T> schemaTree(Class<T> expectedType) {
        RuntimeType[] tmp;
        if (expectedType.isInstance(this.bySchemaTree)) {
            return List.of((RuntimeType)expectedType.cast(this.bySchemaTree));
        }
        for (RuntimeType item : tmp = (RuntimeType[])this.bySchemaTree) {
            Verify.verify((boolean)expectedType.isInstance(item), (String)"Unexpected schema tree child %s", (Object)item);
        }
        return Collections.unmodifiableList(Arrays.asList(tmp));
    }

    private static @NonNull QName extractQName(RuntimeType type) {
        EffectiveStatement stmt = type.statement();
        Verify.verify((boolean)(stmt instanceof SchemaTreeEffectiveStatement), (String)"Unexpected statement %s in %s", (Object)stmt, (Object)type);
        return (QName)((SchemaTreeEffectiveStatement)stmt).argument();
    }
}

