/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.osgi.impl;

import com.google.common.base.Verify;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.osgi.impl.OSGiBindingDOMCodecServicesImpl;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecFactory;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.osgi.OSGiBindingRuntimeContext;
import org.opendaylight.mdsal.dom.schema.osgi.ModelGenerationAware;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public final class OSGiBindingDOMCodec {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiBindingDOMCodec.class);
    @Reference
    BindingDOMCodecFactory codecFactory = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.binding.dom.codec.osgi.impl.OSGiBindingDOMCodecServicesImpl)")
    ComponentFactory contextFactory = null;
    private @GuardedBy(value={"this"}) AbstractInstances instances = new InactiveInstances();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    synchronized void addModuleInfoSnapshot(OSGiBindingRuntimeContext runtimeContext) {
        this.instances.add(runtimeContext);
    }

    synchronized void removeModuleInfoSnapshot(OSGiBindingRuntimeContext runtimeContext) {
        this.instances.remove(runtimeContext);
    }

    @Activate
    synchronized void activate() {
        LOG.info("Binding/DOM Codec activating");
        this.instances = this.instances.toActive(this.codecFactory, this.contextFactory);
        LOG.info("Binding/DOM Codec activated");
    }

    @Deactivate
    synchronized void deactivate() {
        LOG.info("Binding/DOM Codec deactivating");
        this.instances = this.instances.toInactive();
        LOG.info("Binding/DOM Codec deactivated");
    }

    private static final class ActiveInstances
    extends AbstractInstances {
        private final Map<OSGiBindingRuntimeContext, ComponentInstance> instances = new IdentityHashMap<OSGiBindingRuntimeContext, ComponentInstance>();
        private final BindingDOMCodecFactory codecFactory;
        private final ComponentFactory factory;

        ActiveInstances(BindingDOMCodecFactory codecFactory, ComponentFactory factory) {
            this.codecFactory = Objects.requireNonNull(codecFactory);
            this.factory = Objects.requireNonNull(factory);
        }

        @Override
        void add(OSGiBindingRuntimeContext runtimeContext) {
            BindingRuntimeContext context = (BindingRuntimeContext)runtimeContext.getService();
            this.instances.put(runtimeContext, this.factory.newInstance(OSGiBindingDOMCodecServicesImpl.props(runtimeContext.getGeneration(), runtimeContext.getServiceRanking(), this.codecFactory.createBindingDOMCodec(context))));
        }

        @Override
        void remove(OSGiBindingRuntimeContext runtimeContext) {
            ComponentInstance instance = this.instances.remove(runtimeContext);
            if (instance != null) {
                instance.dispose();
            } else {
                LOG.warn("Instance for generation {} not found", (Object)runtimeContext.getGeneration());
            }
        }

        @Override
        AbstractInstances toActive(BindingDOMCodecFactory ignoreCodecFactory, ComponentFactory ignoreFactory) {
            throw new IllegalStateException("Attempted to activate active instances");
        }

        @Override
        AbstractInstances toInactive() {
            this.instances.values().forEach(ComponentInstance::dispose);
            return new InactiveInstances(this.instances.keySet());
        }
    }

    private static final class InactiveInstances
    extends AbstractInstances {
        private final Set<OSGiBindingRuntimeContext> instances = Collections.newSetFromMap(new IdentityHashMap());

        InactiveInstances() {
        }

        InactiveInstances(Set<OSGiBindingRuntimeContext> keySet) {
            this.instances.addAll(keySet);
        }

        @Override
        void add(OSGiBindingRuntimeContext runtimeContext) {
            Verify.verify((boolean)this.instances.add(runtimeContext), (String)"Duplicate instance %s?!", (Object)runtimeContext);
        }

        @Override
        void remove(OSGiBindingRuntimeContext runtimeContext) {
            this.instances.remove(runtimeContext);
        }

        @Override
        AbstractInstances toActive(BindingDOMCodecFactory codecFactory, ComponentFactory factory) {
            ActiveInstances active = new ActiveInstances(codecFactory, factory);
            this.instances.stream().sorted(Comparator.comparing(ModelGenerationAware::getGeneration).reversed()).forEach(active::add);
            return active;
        }

        @Override
        AbstractInstances toInactive() {
            throw new IllegalStateException("Attempted to deactivate inactive instances");
        }
    }

    private static abstract class AbstractInstances {
        private AbstractInstances() {
        }

        abstract void add(OSGiBindingRuntimeContext var1);

        abstract void remove(OSGiBindingRuntimeContext var1);

        abstract @NonNull AbstractInstances toActive(BindingDOMCodecFactory var1, ComponentFactory var2);

        abstract @NonNull AbstractInstances toInactive();
    }
}

