/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.eventexecutor;

import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public interface AutoCloseableEventExecutor
extends EventExecutor,
AutoCloseable {
    public static AutoCloseableEventExecutor globalEventExecutor() {
        return CloseableEventExecutorMixin.createCloseableProxy((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    public static AutoCloseableEventExecutor immediateEventExecutor() {
        return CloseableEventExecutorMixin.createCloseableProxy((EventExecutor)ImmediateEventExecutor.INSTANCE);
    }

    public static class CloseableEventExecutorMixin
    implements AutoCloseable {
        public static final int DEFAULT_SHUTDOWN_SECONDS = 1;
        private final EventExecutor eventExecutor;

        public CloseableEventExecutorMixin(EventExecutor eventExecutor) {
            this.eventExecutor = eventExecutor;
        }

        @Override
        @SuppressFBWarnings(value={"UC_USELESS_VOID_METHOD"}, justification="False positive")
        public void close() {
            this.eventExecutor.shutdownGracefully(0L, 1L, TimeUnit.SECONDS);
        }

        static AutoCloseableEventExecutor createCloseableProxy(EventExecutor eventExecutor) {
            final CloseableEventExecutorMixin closeableEventExecutor = new CloseableEventExecutorMixin(eventExecutor);
            return (AutoCloseableEventExecutor)Reflection.newProxy(AutoCloseableEventExecutor.class, (InvocationHandler)new AbstractInvocationHandler(){

                protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("close")) {
                        closeableEventExecutor.close();
                        return null;
                    }
                    return method.invoke((Object)closeableEventExecutor.eventExecutor, args);
                }
            });
        }
    }
}

