/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.util.SingletonSpliterators;

@Beta
public abstract class SingletonSet<E>
implements Set<E>,
Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final SingletonSet<?> NULL_SINGLETON = new SingletonSet<Object>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean contains(Object o) {
            return o == null;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public @Nullable Object getElement() {
            return null;
        }

        @Override
        public @NonNull Spliterator<Object> spliterator() {
            return SingletonSpliterators.immutableOfNull();
        }

        public @NonNull String toString() {
            return "[null]";
        }

        private Object readResolve() {
            return NULL_SINGLETON;
        }
    };

    public static <E> @NonNull SingletonSet<E> of(@Nullable E element) {
        return element == null ? NULL_SINGLETON : new RegularSingletonSet<E>(element);
    }

    public abstract E getElement();

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final @NonNull Iterator<E> iterator() {
        return Iterators.singletonIterator(this.getElement());
    }

    @Override
    public abstract @NonNull Spliterator<E> spliterator();

    @Override
    public final @NonNull Object[] toArray() {
        return new Object[]{this.getElement()};
    }

    @Override
    public final <T> @NonNull T[] toArray(T[] a) {
        if (a.length > 0) {
            a[0] = this.getElement();
            return a;
        }
        return new Object[]{this.getElement()};
    }

    @Override
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return c.isEmpty() || c.size() == 1 && this.otherContains(c);
    }

    @Override
    public final boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract int hashCode();

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set s = (Set)obj;
        return s.size() == 1 && this.otherContains(s);
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="https://github.com/spotbugs/spotbugs/issues/1954")
    private boolean otherContains(@NonNull Collection<?> other) {
        try {
            return other.contains(this.getElement());
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    @NonNullByDefault
    private static final class RegularSingletonSet<E>
    extends SingletonSet<E> {
        private static final long serialVersionUID = 1L;
        private final E element;

        RegularSingletonSet(E element) {
            this.element = Objects.requireNonNull(element);
        }

        @Override
        public boolean contains(@Nullable Object o) {
            return this.element.equals(o);
        }

        @Override
        public E getElement() {
            return this.element;
        }

        @Override
        public int hashCode() {
            return this.getElement().hashCode();
        }

        public String toString() {
            return "[" + this.element + "]";
        }

        @Override
        public Spliterator<E> spliterator() {
            return SingletonSpliterators.immutableOf(this.element);
        }
    }
}

