/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.primitives.UnsignedLong;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.util.DurationWithTime;

final class SynchronizedDurationStatsTracker
extends DurationStatisticsTracker {
    private static final long NOT_SET = -1L;
    private long durationSum = 0L;
    private long durationCount = 0L;
    private long shortestDuration = -1L;
    private long longestDuration = -1L;
    private long longestTimestamp;
    private long shortestTimestamp;

    SynchronizedDurationStatsTracker() {
    }

    @Override
    public synchronized void addDuration(long duration) {
        this.durationSum += duration;
        ++this.durationCount;
        if (duration < this.shortestDuration || this.shortestDuration == -1L) {
            this.shortestDuration = duration;
            this.shortestTimestamp = System.currentTimeMillis();
        }
        if (duration > this.longestDuration) {
            this.longestDuration = duration;
            this.longestTimestamp = System.currentTimeMillis();
        }
    }

    @Override
    public synchronized double getAverageDuration() {
        return this.durationCount == 0L ? 0.0 : UnsignedLong.fromLongBits((long)this.durationSum).doubleValue() / (double)this.durationCount;
    }

    @Override
    public synchronized long getTotalDurations() {
        return this.durationCount;
    }

    @Override
    public synchronized void reset() {
        this.durationSum = 0L;
        this.durationCount = 0L;
        this.longestDuration = -1L;
        this.shortestDuration = -1L;
    }

    @Override
    protected synchronized DurationWithTime getShortest() {
        return this.shortestDuration == -1L ? null : new DurationWithTime(this.shortestDuration, this.shortestTimestamp);
    }

    @Override
    protected synchronized DurationWithTime getLongest() {
        return this.longestDuration == -1L ? null : new DurationWithTime(this.longestDuration, this.longestTimestamp);
    }
}

