/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.api.ActionProviderService;
import org.opendaylight.mdsal.binding.api.ActionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.adapter.ActionProviderServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.ActionServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataBrokerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMMountPointServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationPublishServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcProviderServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.spi.AdapterFactory;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.yangtools.concepts.Immutable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Singleton
@Beta
@Component(immediate=true, service={AdapterFactory.class})
@NonNullByDefault
public final class BindingAdapterFactory
implements AdapterFactory,
Immutable {
    private final AdapterContext codec;

    public BindingAdapterFactory() {
        this(ServiceLoader.load(AdapterContext.class).findFirst().orElseThrow(() -> new IllegalStateException("Failed to load BlockingBindingNormalizer")));
    }

    @Inject
    @Activate
    public BindingAdapterFactory(@Reference AdapterContext codec) {
        this.codec = Objects.requireNonNull(codec);
    }

    @Override
    public DataBroker createDataBroker(DOMDataBroker domService) {
        return new BindingDOMDataBrokerAdapter(this.codec, domService);
    }

    @Override
    public MountPointService createMountPointService(DOMMountPointService domService) {
        return new BindingDOMMountPointServiceAdapter(this.codec, domService);
    }

    @Override
    public NotificationService createNotificationService(DOMNotificationService domService) {
        return new BindingDOMNotificationServiceAdapter(this.codec, domService);
    }

    @Override
    public NotificationPublishService createNotificationPublishService(DOMNotificationPublishService domService) {
        return new BindingDOMNotificationPublishServiceAdapter(this.codec, domService);
    }

    @Override
    public RpcConsumerRegistry createRpcConsumerRegistry(DOMRpcService domService) {
        return new BindingDOMRpcServiceAdapter(this.codec, domService);
    }

    @Override
    public RpcProviderService createRpcProviderService(DOMRpcProviderService domService) {
        return new BindingDOMRpcProviderServiceAdapter(this.codec, domService);
    }

    @Override
    public ActionService createActionService(DOMActionService domService) {
        return new ActionServiceAdapter(this.codec, domService);
    }

    @Override
    public ActionProviderService createActionProviderService(DOMActionProviderService domService) {
        return new ActionProviderServiceAdapter(this.codec, domService);
    }
}

