/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingLoadingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.RpcServiceAdapter;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.binding.RpcService;

@VisibleForTesting
public final class BindingDOMRpcServiceAdapter
extends AbstractBindingLoadingAdapter<DOMRpcService, Class<? extends RpcService>, RpcServiceAdapter>
implements RpcConsumerRegistry {
    static final BindingDOMAdapterBuilder.Factory<RpcConsumerRegistry> BUILDER_FACTORY = Builder::new;

    public BindingDOMRpcServiceAdapter(AdapterContext adapterContext, DOMRpcService domService) {
        super(adapterContext, domService);
    }

    public <T extends RpcService> T getRpcService(Class<T> rpcService) {
        return (T)((RpcService)rpcService.cast(((RpcServiceAdapter)this.getAdapter(Objects.requireNonNull(rpcService))).getProxy()));
    }

    @Override
    RpcServiceAdapter loadAdapter(Class<? extends RpcService> key) {
        Preconditions.checkArgument((boolean)BindingReflections.isBindingClass(key));
        Preconditions.checkArgument((boolean)key.isInterface(), (Object)"Supplied RPC service type must be interface.");
        return new RpcServiceAdapter(key, this.adapterContext(), (DOMRpcService)this.getDelegate());
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<RpcConsumerRegistry> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMRpcService.class);
        }

        @Override
        protected RpcConsumerRegistry createInstance(ClassToInstanceMap<DOMService> delegates) {
            return new BindingDOMRpcServiceAdapter(this.adapterContext(), (DOMRpcService)delegates.getInstance(DOMRpcService.class));
        }
    }
}

