/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Map;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractForwardedTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

class BindingDOMWriteTransactionAdapter<T extends DOMDataTreeWriteTransaction>
extends AbstractForwardedTransaction<T>
implements WriteTransaction {
    BindingDOMWriteTransactionAdapter(AdapterContext adapterContext, T delegateTx) {
        super(adapterContext, delegateTx);
    }

    public final <U extends DataObject> void put(LogicalDatastoreType store, InstanceIdentifier<U> path, U data) {
        Map.Entry<YangInstanceIdentifier, NormalizedNode> normalized = this.toNormalized("put", path, data);
        ((DOMDataTreeWriteTransaction)this.getDelegate()).put(store, normalized.getKey(), normalized.getValue());
    }

    public final <U extends DataObject> void mergeParentStructurePut(LogicalDatastoreType store, InstanceIdentifier<U> path, U data) {
        CurrentAdapterSerializer serializer = this.adapterContext().currentSerializer();
        Map.Entry<YangInstanceIdentifier, NormalizedNode> normalized = BindingDOMWriteTransactionAdapter.toNormalized(serializer, "put", path, data);
        this.ensureParentsByMerge(serializer, store, normalized.getKey(), path);
        ((DOMDataTreeWriteTransaction)this.getDelegate()).put(store, normalized.getKey(), normalized.getValue());
    }

    public final <D extends DataObject> void merge(LogicalDatastoreType store, InstanceIdentifier<D> path, D data) {
        Map.Entry<YangInstanceIdentifier, NormalizedNode> normalized = this.toNormalized("merge", path, data);
        ((DOMDataTreeWriteTransaction)this.getDelegate()).merge(store, normalized.getKey(), normalized.getValue());
    }

    public final <U extends DataObject> void mergeParentStructureMerge(LogicalDatastoreType store, InstanceIdentifier<U> path, U data) {
        CurrentAdapterSerializer serializer = this.adapterContext().currentSerializer();
        Map.Entry<YangInstanceIdentifier, NormalizedNode> normalized = BindingDOMWriteTransactionAdapter.toNormalized(serializer, "merge", path, data);
        this.ensureParentsByMerge(serializer, store, normalized.getKey(), path);
        ((DOMDataTreeWriteTransaction)this.getDelegate()).merge(store, normalized.getKey(), normalized.getValue());
    }

    public final void delete(LogicalDatastoreType store, InstanceIdentifier<?> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Cannot delete wildcarded path %s", path);
        ((DOMDataTreeWriteTransaction)this.getDelegate()).delete(store, this.adapterContext().currentSerializer().toYangInstanceIdentifier(path));
    }

    public FluentFuture<? extends CommitInfo> commit() {
        return ((DOMDataTreeWriteTransaction)this.getDelegate()).commit();
    }

    public final boolean cancel() {
        return ((DOMDataTreeWriteTransaction)this.getDelegate()).cancel();
    }

    private void ensureParentsByMerge(CurrentAdapterSerializer serializer, LogicalDatastoreType store, YangInstanceIdentifier domPath, InstanceIdentifier<?> path) {
        YangInstanceIdentifier parentPath = domPath.getParent();
        if (parentPath != null && !parentPath.isEmpty()) {
            NormalizedNode parentNode = ImmutableNodes.fromInstanceId((EffectiveModelContext)serializer.getRuntimeContext().getEffectiveModelContext(), (YangInstanceIdentifier)parentPath);
            ((DOMDataTreeWriteTransaction)this.getDelegate()).merge(store, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument)parentNode.getIdentifier()), parentNode);
        }
    }

    private <U extends DataObject> Map.Entry<YangInstanceIdentifier, NormalizedNode> toNormalized(String operation, InstanceIdentifier<U> path, U data) {
        return BindingDOMWriteTransactionAdapter.toNormalized(this.adapterContext().currentSerializer(), operation, path, data);
    }

    private static <U extends DataObject> Map.Entry<YangInstanceIdentifier, NormalizedNode> toNormalized(CurrentAdapterSerializer serializer, String operation, InstanceIdentifier<U> path, U data) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Cannot %s data into wildcarded path %s", (Object)operation, path);
        return serializer.toNormalizedNode(path, data);
    }
}

