/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableBiMap;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.ActionSpec;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.InstanceNotificationSpec;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.binding.dom.codec.spi.ForwardingBindingDOMCodecServices;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@VisibleForTesting
public final class CurrentAdapterSerializer
extends ForwardingBindingDOMCodecServices {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentAdapterSerializer.class);
    private final LoadingCache<InstanceIdentifier<?>, YangInstanceIdentifier> cache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<InstanceIdentifier<?>, YangInstanceIdentifier>(){

        public YangInstanceIdentifier load(InstanceIdentifier<?> key) {
            return CurrentAdapterSerializer.this.toYangInstanceIdentifier(key);
        }
    });
    private final @NonNull BindingDOMCodecServices delegate;

    public CurrentAdapterSerializer(BindingDOMCodecServices delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected BindingDOMCodecServices delegate() {
        return this.delegate;
    }

    @NonNull YangInstanceIdentifier toCachedYangInstanceIdentifier(@NonNull InstanceIdentifier<?> path) {
        return (YangInstanceIdentifier)this.cache.getUnchecked(path);
    }

    <T extends DataObject> @NonNull InstanceIdentifier<T> coerceInstanceIdentifier(YangInstanceIdentifier dom) {
        return (InstanceIdentifier)Verify.verifyNotNull((Object)this.fromYangInstanceIdentifier(dom));
    }

    DOMDataTreeIdentifier toDOMDataTreeIdentifier(DataTreeIdentifier<?> path) {
        return new DOMDataTreeIdentifier(path.getDatastoreType(), this.toYangInstanceIdentifier(path.getRootIdentifier()));
    }

    Collection<DOMDataTreeIdentifier> toDOMDataTreeIdentifiers(Collection<DataTreeIdentifier<?>> subtrees) {
        return subtrees.stream().map(this::toDOMDataTreeIdentifier).collect(Collectors.toSet());
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute getActionPath(@NonNull ActionSpec<?, ?> spec) {
        Map.Entry<SchemaInferenceStack, QNameModule> entry = this.resolvePath(spec.path());
        SchemaInferenceStack stack = entry.getKey();
        SchemaTreeEffectiveStatement stmt = stack.enterSchemaTree(BindingReflections.findQName((Class)spec.type()).bindTo(entry.getValue()));
        Verify.verify((boolean)(stmt instanceof ActionEffectiveStatement), (String)"Action %s resolved to unexpected statement %s", spec, (Object)stmt);
        return stack.toSchemaNodeIdentifier();
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute getNotificationPath(@NonNull InstanceNotificationSpec<?, ?> spec) {
        Map.Entry<SchemaInferenceStack, QNameModule> entry = this.resolvePath(spec.path());
        SchemaInferenceStack stack = entry.getKey();
        SchemaTreeEffectiveStatement stmt = stack.enterSchemaTree(BindingReflections.findQName((Class)spec.type()).bindTo(entry.getValue()));
        Verify.verify((boolean)(stmt instanceof NotificationEffectiveStatement), (String)"Notification %s resolved to unexpected statement %s", spec, (Object)stmt);
        return stack.toSchemaNodeIdentifier();
    }

    private @NonNull Map.Entry<SchemaInferenceStack, QNameModule> resolvePath(@NonNull InstanceIdentifier<?> path) {
        QNameModule lastNamespace;
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)this.getRuntimeContext().getEffectiveModelContext());
        Iterator it = this.toYangInstanceIdentifier(path).getPathArguments().iterator();
        Verify.verify((boolean)it.hasNext(), (String)"Unexpected empty instance identifier for %s", path);
        do {
            YangInstanceIdentifier.PathArgument arg;
            if ((arg = (YangInstanceIdentifier.PathArgument)it.next()) instanceof YangInstanceIdentifier.AugmentationIdentifier) {
                Set augChildren = ((YangInstanceIdentifier.AugmentationIdentifier)arg).getPossibleChildNames();
                Verify.verify((!augChildren.isEmpty() ? 1 : 0) != 0, (String)"Invalid empty augmentation %s", (Object)arg);
                lastNamespace = ((QName)augChildren.iterator().next()).getModule();
                continue;
            }
            QName qname = arg.getNodeType();
            DataTreeEffectiveStatement stmt = stack.enterDataTree(qname);
            lastNamespace = qname.getModule();
            if (!(stmt instanceof ListEffectiveStatement)) continue;
            Verify.verify((boolean)it.hasNext(), (String)"Unexpected list termination at %s in %s", (Object)stmt, path);
            YangInstanceIdentifier.PathArgument skipped = (YangInstanceIdentifier.PathArgument)it.next();
            Verify.verify((boolean)(skipped instanceof YangInstanceIdentifier.NodeIdentifier), (String)"Unexpected skipped list entry item %s in %s", (Object)skipped, path);
            Verify.verify((boolean)((QName)stmt.argument()).equals((Object)skipped.getNodeType()), (String)"Mismatched list entry item %s in %s", (Object)skipped, path);
        } while (it.hasNext());
        return Map.entry(stack, lastNamespace);
    }

    ImmutableBiMap<Method, RpcDefinition> getRpcMethodToSchema(Class<? extends RpcService> key) {
        Module module = this.getModule(key);
        ImmutableBiMap.Builder ret = ImmutableBiMap.builder();
        try {
            for (RpcDefinition rpcDef : module.getRpcs()) {
                Method method = this.findRpcMethod(key, rpcDef);
                ret.put((Object)method, (Object)rpcDef);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Rpc defined in model does not have representation in generated class.", e);
        }
        return ret.build();
    }

    ImmutableBiMap<Method, QName> getRpcMethodToQName(Class<? extends RpcService> key) {
        Module module = this.getModule(key);
        ImmutableBiMap.Builder ret = ImmutableBiMap.builder();
        try {
            for (RpcDefinition rpcDef : module.getRpcs()) {
                Method method = this.findRpcMethod(key, rpcDef);
                ret.put((Object)method, (Object)rpcDef.getQName());
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Rpc defined in model does not have representation in generated class.", e);
        }
        return ret.build();
    }

    private Module getModule(Class<?> modeledClass) {
        QNameModule moduleName = BindingReflections.getQNameModule(modeledClass);
        BindingRuntimeContext localRuntimeContext = this.getRuntimeContext();
        Module module = localRuntimeContext.getEffectiveModelContext().findModule(moduleName).orElse(null);
        if (module != null) {
            return module;
        }
        LOG.trace("Schema for {} is not available; expected module name: {}; BindingRuntimeContext: {}", new Object[]{modeledClass, moduleName, localRuntimeContext});
        throw new IllegalStateException(String.format("Schema for %s is not available; expected module name: %s; full BindingRuntimeContext available in trace log", modeledClass, moduleName));
    }

    private Method findRpcMethod(Class<? extends RpcService> key, RpcDefinition rpcDef) throws NoSuchMethodException {
        QName rpcName = rpcDef.getQName();
        Class inputClz = this.getRuntimeContext().getRpcInput(rpcName);
        return key.getMethod(BindingMapping.getRpcMethodName((QName)rpcName), inputClz);
    }
}

