/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.dom.adapter.BindingStructuralType;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LazyDataObjectModification<T extends DataObject>
implements DataObjectModification<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyDataObjectModification.class);
    private final BindingDataObjectCodecTreeNode<T> codec;
    private final DataTreeCandidateNode domData;
    private final InstanceIdentifier.PathArgument identifier;
    private volatile Collection<LazyDataObjectModification<? extends DataObject>> childNodesCache;
    private volatile DataObjectModification.ModificationType modificationType;

    private LazyDataObjectModification(BindingDataObjectCodecTreeNode<T> codec, DataTreeCandidateNode domData) {
        this.codec = Objects.requireNonNull(codec);
        this.domData = Objects.requireNonNull(domData);
        this.identifier = codec.deserializePathArgument(domData.getIdentifier());
    }

    static <T extends DataObject> LazyDataObjectModification<T> create(BindingDataObjectCodecTreeNode<T> codec, DataTreeCandidateNode domData) {
        return new LazyDataObjectModification<T>(codec, domData);
    }

    private static Collection<LazyDataObjectModification<? extends DataObject>> from(BindingDataObjectCodecTreeNode<?> parentCodec, Collection<DataTreeCandidateNode> domChildNodes) {
        ArrayList<LazyDataObjectModification<? extends DataObject>> result = new ArrayList<LazyDataObjectModification<? extends DataObject>>(domChildNodes.size());
        LazyDataObjectModification.populateList(result, parentCodec, domChildNodes);
        return result;
    }

    private static void populateList(List<LazyDataObjectModification<? extends DataObject>> result, BindingDataObjectCodecTreeNode<?> parentCodec, Collection<DataTreeCandidateNode> domChildNodes) {
        for (DataTreeCandidateNode domChildNode : domChildNodes) {
            BindingStructuralType type;
            if (domChildNode.getModificationType() == ModificationType.UNMODIFIED || (type = BindingStructuralType.from(domChildNode)) == BindingStructuralType.NOT_ADDRESSABLE) continue;
            try {
                BindingCodecTreeNode childCodec = parentCodec.yangPathArgumentChild(domChildNode.getIdentifier());
                Verify.verify((boolean)(childCodec instanceof BindingDataObjectCodecTreeNode), (String)"Unhandled codec %s for type %s", (Object)childCodec, (Object)((Object)type));
                LazyDataObjectModification.populateList(result, type, (BindingDataObjectCodecTreeNode)childCodec, domChildNode);
            }
            catch (IllegalArgumentException e) {
                if (type == BindingStructuralType.UNKNOWN) {
                    LOG.debug("Unable to deserialize unknown DOM node {}", (Object)domChildNode, (Object)e);
                    continue;
                }
                LOG.debug("Binding representation for DOM node {} was not found", (Object)domChildNode, (Object)e);
            }
        }
    }

    private static void populateList(List<LazyDataObjectModification<? extends DataObject>> result, BindingStructuralType type, BindingDataObjectCodecTreeNode<?> childCodec, DataTreeCandidateNode domChildNode) {
        switch (type) {
            case INVISIBLE_LIST: {
                LazyDataObjectModification.populateListWithSingleCodec(result, childCodec, domChildNode.getChildNodes());
                break;
            }
            case INVISIBLE_CONTAINER: {
                LazyDataObjectModification.populateList(result, childCodec, domChildNode.getChildNodes());
                break;
            }
            case UNKNOWN: 
            case VISIBLE_CONTAINER: {
                result.add(LazyDataObjectModification.create(childCodec, domChildNode));
                break;
            }
        }
    }

    private static void populateListWithSingleCodec(List<LazyDataObjectModification<? extends DataObject>> result, BindingDataObjectCodecTreeNode<?> codec, Collection<DataTreeCandidateNode> childNodes) {
        for (DataTreeCandidateNode child : childNodes) {
            if (child.getModificationType() == ModificationType.UNMODIFIED) continue;
            result.add(LazyDataObjectModification.create(codec, child));
        }
    }

    public T getDataBefore() {
        return this.deserialize(this.domData.getDataBefore());
    }

    public T getDataAfter() {
        return this.deserialize(this.domData.getDataAfter());
    }

    public Class<T> getDataType() {
        return this.codec.getBindingClass();
    }

    public InstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    public DataObjectModification.ModificationType getModificationType() {
        DataObjectModification.ModificationType localType = this.modificationType;
        if (localType != null) {
            return localType;
        }
        switch (this.domData.getModificationType()) {
            case APPEARED: 
            case WRITE: {
                localType = DataObjectModification.ModificationType.WRITE;
                break;
            }
            case DISAPPEARED: 
            case DELETE: {
                localType = DataObjectModification.ModificationType.DELETE;
                break;
            }
            case SUBTREE_MODIFIED: {
                localType = this.resolveSubtreeModificationType();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported DOM Modification type " + this.domData.getModificationType());
            }
        }
        this.modificationType = localType;
        return localType;
    }

    private DataObjectModification.ModificationType resolveSubtreeModificationType() {
        switch (this.codec.getChildAddressabilitySummary()) {
            case ADDRESSABLE: {
                return DataObjectModification.ModificationType.SUBTREE_MODIFIED;
            }
            case UNADDRESSABLE: {
                return DataObjectModification.ModificationType.WRITE;
            }
            case MIXED: {
                for (DataTreeCandidateNode child : this.domData.getChildNodes()) {
                    if (BindingStructuralType.recursiveFrom(child) != BindingStructuralType.NOT_ADDRESSABLE) continue;
                    return DataObjectModification.ModificationType.WRITE;
                }
                return DataObjectModification.ModificationType.SUBTREE_MODIFIED;
            }
        }
        throw new IllegalStateException("Unsupported child addressability summary " + this.codec.getChildAddressabilitySummary());
    }

    public Collection<LazyDataObjectModification<? extends DataObject>> getModifiedChildren() {
        Collection<LazyDataObjectModification<? extends DataObject>> local = this.childNodesCache;
        if (local == null) {
            this.childNodesCache = local = LazyDataObjectModification.from(this.codec, this.domData.getChildNodes());
        }
        return local;
    }

    public <C extends ChildOf<? super T>> Collection<DataObjectModification<C>> getModifiedChildren(Class<C> childType) {
        return this.streamModifiedChildren(childType).collect(Collectors.toList());
    }

    public <H extends ChoiceIn<? super T> & DataObject, C extends ChildOf<? super H>> Collection<DataObjectModification<C>> getModifiedChildren(Class<H> caseType, Class<C> childType) {
        return this.streamModifiedChildren(childType).filter(child -> caseType.equals(child.identifier.getCaseType().orElse(null))).collect(Collectors.toList());
    }

    private <C extends DataObject> Stream<LazyDataObjectModification<C>> streamModifiedChildren(Class<C> childType) {
        return this.getModifiedChildren().stream().filter(child -> childType.isAssignableFrom(child.getDataType())).map(child -> child);
    }

    public DataObjectModification<? extends DataObject> getModifiedChild(InstanceIdentifier.PathArgument arg) {
        ArrayList domArgumentList = new ArrayList();
        BindingDataObjectCodecTreeNode childCodec = this.codec.bindingPathArgumentChild(arg, domArgumentList);
        Iterator toEnter = domArgumentList.iterator();
        DataTreeCandidateNode current = this.domData;
        while (toEnter.hasNext() && current != null) {
            current = current.getModifiedChild((YangInstanceIdentifier.PathArgument)toEnter.next()).orElse(null);
        }
        return current != null && current.getModificationType() != ModificationType.UNMODIFIED ? LazyDataObjectModification.create(childCodec, current) : null;
    }

    public <C extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<C>> DataObjectModification<C> getModifiedChildListItem(Class<C> listItem, K listKey) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)InstanceIdentifier.IdentifiableItem.of(listItem, listKey));
    }

    public <H extends ChoiceIn<? super T> & DataObject, C extends Identifiable<K> & ChildOf<? super H>, K extends Identifier<C>> DataObjectModification<C> getModifiedChildListItem(Class<H> caseType, Class<C> listItem, K listKey) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)InstanceIdentifier.IdentifiableItem.of(caseType, listItem, listKey));
    }

    public <C extends ChildOf<? super T>> DataObjectModification<C> getModifiedChildContainer(Class<C> child) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)InstanceIdentifier.Item.of(child));
    }

    public <H extends ChoiceIn<? super T> & DataObject, C extends ChildOf<? super H>> DataObjectModification<C> getModifiedChildContainer(Class<H> caseType, Class<C> child) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)InstanceIdentifier.Item.of(caseType, child));
    }

    public <C extends Augmentation<T> & DataObject> DataObjectModification<C> getModifiedAugmentation(Class<C> augmentation) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)InstanceIdentifier.Item.of(augmentation));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.identifier).add("domData", (Object)this.domData).toString();
    }

    private T deserialize(Optional<NormalizedNode> dataAfter) {
        return (T)((DataObject)dataAfter.map(arg_0 -> this.codec.deserialize(arg_0)).orElse(null));
    }
}

