/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractDOMNotificationListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

final class SingleBindingDOMNotificationAdapter<N extends Notification<N> & DataObject>
extends AbstractDOMNotificationListenerAdapter {
    private final NotificationService.Listener<N> delegate;
    private final Executor executor;
    private final Class<N> type;

    SingleBindingDOMNotificationAdapter(AdapterContext adapterContext, Class<N> type, NotificationService.Listener<N> delegate, Executor executor) {
        super(adapterContext);
        this.type = Objects.requireNonNull(type);
        this.delegate = Objects.requireNonNull(delegate);
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    void onNotification(SchemaNodeIdentifier.Absolute domType, Notification<?> notification) {
        this.executor.execute(() -> this.delegate.onNotification((Notification)this.type.cast(notification)));
    }

    @Override
    Set<SchemaNodeIdentifier.Absolute> getSupportedNotifications() {
        return Set.of(SchemaNodeIdentifier.Absolute.of((QName)BindingReflections.findQName(this.type)));
    }
}

