/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.invoke;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

final class RpcMethodInvoker {
    private static final MethodType INVOCATION_SIGNATURE = MethodType.methodType(ListenableFuture.class, RpcService.class, DataObject.class);
    private final MethodHandle handle;

    @VisibleForTesting
    RpcMethodInvoker(MethodHandle handle) {
        this.handle = handle.asType(INVOCATION_SIGNATURE);
    }

    static RpcMethodInvoker from(Method method) {
        MethodHandle methodHandle;
        BindingReflections.resolveRpcInputClass((Method)method).orElseThrow(() -> new IllegalArgumentException("Method " + method + " does not have an input argument"));
        try {
            methodHandle = MethodHandles.publicLookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Lookup on public method failed.", e);
        }
        return new RpcMethodInvoker(methodHandle);
    }

    ListenableFuture<RpcResult<?>> invokeOn(RpcService impl, DataObject input) {
        try {
            return this.handle.invokeExact(impl, input);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

