/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.invoke;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.ClassBasedRpcServiceInvoker;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.LocalNameRpcServiceInvoker;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.QNameRpcServiceInvoker;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcServiceInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(RpcServiceInvoker.class);

    @Deprecated(forRemoval=true, since="9.0.6")
    public static RpcServiceInvoker from(Class<? extends RpcService> type) {
        return ClassBasedRpcServiceInvoker.instanceFor(type);
    }

    public static RpcServiceInvoker from(Map<QName, Method> qnameToMethod) {
        Preconditions.checkArgument((!qnameToMethod.isEmpty() ? 1 : 0) != 0);
        QNameModule module = null;
        for (QName qname : qnameToMethod.keySet()) {
            if (module != null) {
                if (module.equals((Object)qname.getModule())) continue;
                LOG.debug("QNames from different modules {} and {}, falling back to QName map", (Object)module, (Object)qname.getModule());
                return QNameRpcServiceInvoker.instanceFor(qnameToMethod);
            }
            module = qname.getModule();
        }
        return LocalNameRpcServiceInvoker.instanceFor(module, qnameToMethod);
    }

    public abstract ListenableFuture<RpcResult<?>> invokeRpc(@NonNull RpcService var1, @NonNull QName var2, @Nullable DataObject var3);
}

