/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.query.DescendantQueryBuilder;
import org.opendaylight.mdsal.binding.api.query.QueryFactory;
import org.opendaylight.mdsal.binding.api.query.QueryStructureException;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultDescendantQueryBuilder;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingSchemaMapping;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Beta
public final class DefaultQueryFactory
implements QueryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultQueryFactory.class);
    private final LoadingCache<MethodId, YangInstanceIdentifier.NodeIdentifier> knownMethods = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<MethodId, YangInstanceIdentifier.NodeIdentifier>(){

        public YangInstanceIdentifier.NodeIdentifier load(MethodId key) {
            DataNodeContainer parent = key.parent;
            String methodName = key.methodName;
            for (DataSchemaNode child : parent.getChildNodes()) {
                if (!methodName.equals(BindingSchemaMapping.getGetterMethodName((DataSchemaNode)child))) continue;
                return YangInstanceIdentifier.NodeIdentifier.create((QName)child.getQName());
            }
            throw new QueryStructureException("Failed to find schema matching " + methodName + " in " + parent);
        }
    });
    private final @NonNull BindingCodecTree codec;

    public DefaultQueryFactory() {
        this(ServiceLoader.load(BindingCodecTree.class).findFirst().orElseThrow());
    }

    @Inject
    public DefaultQueryFactory(BindingCodecTree codec) {
        this.codec = Objects.requireNonNull(codec);
    }

    public <T extends DataObject> DescendantQueryBuilder<T> querySubtree(InstanceIdentifier<T> rootPath) {
        return new DefaultDescendantQueryBuilder(this, rootPath);
    }

    @NonNull BindingCodecTree codec() {
        return this.codec;
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier findChild(DataNodeContainer parent, String methodName) {
        try {
            return (YangInstanceIdentifier.NodeIdentifier)this.knownMethods.get((Object)new MethodId(parent, methodName));
        }
        catch (ExecutionException e) {
            LOG.debug("Failed to find method for {}", (Object)methodName, (Object)e);
            Throwable cause = e.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new IllegalStateException("Failed to load cache", e);
        }
    }

    private static final class MethodId {
        final DataNodeContainer parent;
        final String methodName;

        MethodId(DataNodeContainer parent, String methodName) {
            this.parent = Objects.requireNonNull(parent);
            this.methodName = Objects.requireNonNull(methodName);
        }

        public int hashCode() {
            return this.parent.hashCode() * 31 + this.methodName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodId)) {
                return false;
            }
            MethodId other = (MethodId)obj;
            return this.methodName.equals(other.methodName) && this.parent.equals(other.parent);
        }
    }
}

