/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.query.QueryResult;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQueryResult;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@NonNullByDefault
final class DefaultQueryResultItem<T extends DataObject>
implements QueryResult.Item<T> {
    private static final VarHandle OBJECT;
    private static final VarHandle PATH;
    private final Map.Entry<YangInstanceIdentifier, NormalizedNode> domItem;
    private final DefaultQueryResult<T> result;
    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"}, justification="Ungrokked type annotation")
    private volatile @Nullable InstanceIdentifier<T> path = null;
    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"}, justification="Ungrokked type annotation")
    private volatile @Nullable T object = null;

    DefaultQueryResultItem(DefaultQueryResult<T> result, Map.Entry<YangInstanceIdentifier, NormalizedNode> domItem) {
        this.result = Objects.requireNonNull(result);
        this.domItem = Objects.requireNonNull(domItem);
    }

    public T object() {
        @Nullable DataObject local = OBJECT.getAcquire(this);
        return (T)(local != null ? local : this.loadObject());
    }

    public InstanceIdentifier<T> path() {
        @Nullable InstanceIdentifier<T> local = PATH.getAcquire(this);
        return local != null ? local : this.loadPath();
    }

    private T loadObject() {
        T ret = this.result.createObject(this.domItem);
        Object witness = OBJECT.compareAndExchangeRelease(this, null, (DataObject)ret);
        return (T)(witness == null ? ret : (DataObject)witness);
    }

    private InstanceIdentifier<T> loadPath() {
        InstanceIdentifier ret = this.result.createPath(this.domItem.getKey());
        Object witness = PATH.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : (InstanceIdentifier)witness;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            OBJECT = lookup.findVarHandle(DefaultQueryResultItem.class, "object", DataObject.class);
            PATH = lookup.findVarHandle(DefaultQueryResultItem.class, "path", InstanceIdentifier.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

