/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.ObjectStreamException;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.HashCodeBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class FixedYangInstanceIdentifier
extends YangInstanceIdentifier
implements Cloneable {
    static final @NonNull FixedYangInstanceIdentifier EMPTY_INSTANCE = new FixedYangInstanceIdentifier((ImmutableList<YangInstanceIdentifier.PathArgument>)ImmutableList.of(), new HashCodeBuilder().build());
    private static final long serialVersionUID = 1L;
    private final ImmutableList<YangInstanceIdentifier.PathArgument> path;
    private volatile transient YangInstanceIdentifier parent;

    FixedYangInstanceIdentifier(ImmutableList<YangInstanceIdentifier.PathArgument> path, int hash) {
        super(hash);
        this.path = Objects.requireNonNull(path, "path must not be null.");
    }

    static @NonNull FixedYangInstanceIdentifier create(Iterable<? extends YangInstanceIdentifier.PathArgument> path, int hash) {
        return new FixedYangInstanceIdentifier((ImmutableList<YangInstanceIdentifier.PathArgument>)ImmutableList.copyOf(path), hash);
    }

    @Override
    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public FixedYangInstanceIdentifier clone() {
        try {
            return (FixedYangInstanceIdentifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("clone() should be supported", e);
        }
    }

    @Override
    public YangInstanceIdentifier getParent() {
        if (this.path.isEmpty()) {
            return null;
        }
        YangInstanceIdentifier ret = this.parent;
        if (ret == null) {
            this.parent = ret = YangInstanceIdentifier.create((Iterable<? extends YangInstanceIdentifier.PathArgument>)this.path.subList(0, this.path.size() - 1));
        }
        return ret;
    }

    @Override
    public YangInstanceIdentifier coerceParent() {
        return (YangInstanceIdentifier)Verify.verifyNotNull((Object)this.getParent(), (String)"Empty instance identifier does not have a parent", (Object[])new Object[0]);
    }

    @Override
    public YangInstanceIdentifier getAncestor(int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"Negative depth is not allowed");
        Preconditions.checkArgument((depth <= this.path.size() ? 1 : 0) != 0, (String)"Depth %s exceeds maximum depth %s", (int)depth, (int)this.path.size());
        if (depth == this.path.size()) {
            return this;
        }
        if (depth == this.path.size() - 1) {
            return (YangInstanceIdentifier)Verify.verifyNotNull((Object)this.getParent());
        }
        return YangInstanceIdentifier.create((Iterable<? extends YangInstanceIdentifier.PathArgument>)this.path.subList(0, depth));
    }

    @Override
    public List<YangInstanceIdentifier.PathArgument> getPathArguments() {
        return this.path;
    }

    @Override
    public List<YangInstanceIdentifier.PathArgument> getReversePathArguments() {
        return this.path.reverse();
    }

    @NonNull List<YangInstanceIdentifier.PathArgument> tryPathArguments() {
        return this.path;
    }

    @NonNull List<YangInstanceIdentifier.PathArgument> tryReversePathArguments() {
        return this.path.reverse();
    }

    @Override
    public YangInstanceIdentifier.PathArgument getLastPathArgument() {
        return this.path.isEmpty() ? null : (YangInstanceIdentifier.PathArgument)this.path.get(this.path.size() - 1);
    }

    @Override
    YangInstanceIdentifier createRelativeIdentifier(int skipFromRoot) {
        if (skipFromRoot == this.path.size()) {
            return EMPTY_INSTANCE;
        }
        ImmutableList newPath = this.path.subList(skipFromRoot, this.path.size());
        HashCodeBuilder hash = new HashCodeBuilder();
        for (YangInstanceIdentifier.PathArgument a : newPath) {
            hash.addArgument((Object)a);
        }
        return new FixedYangInstanceIdentifier((ImmutableList<YangInstanceIdentifier.PathArgument>)newPath, hash.build());
    }

    private Object readResolve() throws ObjectStreamException {
        return this.path.isEmpty() ? EMPTY_INSTANCE : this;
    }

    @Override
    boolean pathArgumentsEqual(YangInstanceIdentifier other) {
        if (other instanceof FixedYangInstanceIdentifier) {
            return this.path.equals(((FixedYangInstanceIdentifier)other).path);
        }
        return super.pathArgumentsEqual(other);
    }

    @Override
    public FixedYangInstanceIdentifier toOptimized() {
        return this;
    }
}

