/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.YangErrorInfo;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangNetconfError;

@SuppressFBWarnings
public final class ImmutableYangNetconfError
implements YangNetconfError {
    private final ErrorSeverity severity;
    private final ErrorType type;
    private final ErrorTag tag;
    private final @Nullable String message;
    private final @Nullable String appTag;
    private final @Nullable YangInstanceIdentifier path;
    private final ImmutableList<YangErrorInfo> info;

    private ImmutableYangNetconfError(Builder builder) {
        this.severity = builder.severity;
        this.type = builder.type;
        this.tag = builder.tag;
        this.message = builder.message;
        this.appTag = builder.appTag;
        this.path = builder.path;
        this.info = builder.info.build();
    }

    @Override
    public ErrorSeverity severity() {
        return this.severity;
    }

    @Override
    public ErrorType type() {
        return this.type;
    }

    @Override
    public ErrorTag tag() {
        return this.tag;
    }

    @Override
    public @Nullable String message() {
        return this.message;
    }

    @Override
    public @Nullable String appTag() {
        return this.appTag;
    }

    @Override
    public @Nullable YangInstanceIdentifier path() {
        return this.path;
    }

    public ImmutableList<YangErrorInfo> info() {
        return this.info;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableYangNetconfError && this.equalTo(0, (ImmutableYangNetconfError)another);
    }

    private boolean equalTo(int synthetic, ImmutableYangNetconfError another) {
        return this.severity.equals((Object)another.severity) && this.type.equals((Object)another.type) && this.tag.equals((Object)another.tag) && Objects.equals(this.message, another.message) && Objects.equals(this.appTag, another.appTag) && Objects.equals(this.path, another.path) && this.info.equals(another.info);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.severity.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.tag.hashCode();
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.appTag);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + this.info.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"YangNetconfError").omitNullValues().add("severity", (Object)this.severity).add("type", (Object)this.type).add("tag", (Object)this.tag).add("message", (Object)this.message).add("appTag", (Object)this.appTag).add("path", (Object)this.path).add("info", this.info).toString();
    }

    public static SeverityBuildStage builder() {
        return new Builder();
    }

    public static interface BuildFinal {
        public BuildFinal message(@Nullable String var1);

        public BuildFinal appTag(@Nullable String var1);

        public BuildFinal path(@Nullable YangInstanceIdentifier var1);

        public BuildFinal addInfo(YangErrorInfo var1);

        public BuildFinal addInfo(YangErrorInfo ... var1);

        public BuildFinal addAllInfo(Iterable<? extends YangErrorInfo> var1);

        public ImmutableYangNetconfError build();
    }

    public static interface TagBuildStage {
        public BuildFinal tag(ErrorTag var1);
    }

    public static interface TypeBuildStage {
        public TagBuildStage type(ErrorType var1);
    }

    public static interface SeverityBuildStage {
        public TypeBuildStage severity(ErrorSeverity var1);
    }

    public static final class Builder
    implements SeverityBuildStage,
    TypeBuildStage,
    TagBuildStage,
    BuildFinal {
        private static final long INIT_BIT_SEVERITY = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_TAG = 4L;
        private static final long OPT_BIT_MESSAGE = 1L;
        private static final long OPT_BIT_APP_TAG = 2L;
        private static final long OPT_BIT_PATH = 4L;
        private long initBits = 7L;
        private long optBits;
        private ErrorSeverity severity;
        private ErrorType type;
        private ErrorTag tag;
        private @Nullable String message;
        private @Nullable String appTag;
        private @Nullable YangInstanceIdentifier path;
        private final ImmutableList.Builder<YangErrorInfo> info = ImmutableList.builder();

        private Builder() {
        }

        @Override
        public final Builder severity(ErrorSeverity severity) {
            Builder.checkNotIsSet(this.severityIsSet(), "severity");
            this.severity = Objects.requireNonNull(severity, "severity");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder type(ErrorType type) {
            Builder.checkNotIsSet(this.typeIsSet(), "type");
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder tag(ErrorTag tag) {
            Builder.checkNotIsSet(this.tagIsSet(), "tag");
            this.tag = Objects.requireNonNull(tag, "tag");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public final Builder message(@Nullable String message) {
            Builder.checkNotIsSet(this.messageIsSet(), "message");
            this.message = message;
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder appTag(@Nullable String appTag) {
            Builder.checkNotIsSet(this.appTagIsSet(), "appTag");
            this.appTag = appTag;
            this.optBits |= 2L;
            return this;
        }

        @Override
        public final Builder path(@Nullable YangInstanceIdentifier path) {
            Builder.checkNotIsSet(this.pathIsSet(), "path");
            this.path = path;
            this.optBits |= 4L;
            return this;
        }

        @Override
        public final Builder addInfo(YangErrorInfo element) {
            this.info.add((Object)element);
            return this;
        }

        @Override
        public final Builder addInfo(YangErrorInfo ... elements) {
            this.info.add((Object[])elements);
            return this;
        }

        @Override
        public final Builder addAllInfo(Iterable<? extends YangErrorInfo> elements) {
            this.info.addAll(elements);
            return this;
        }

        @Override
        public ImmutableYangNetconfError build() {
            this.checkRequiredAttributes();
            return new ImmutableYangNetconfError(this);
        }

        private boolean messageIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean appTagIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pathIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean severityIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean tagIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of YangNetconfError is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.severityIsSet()) {
                attributes.add("severity");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tagIsSet()) {
                attributes.add("tag");
            }
            return "Cannot build YangNetconfError, some of required attributes are not set " + attributes;
        }
    }
}

