/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;

public final class YangInstanceIdentifierWriter
implements AutoCloseable {
    private NormalizedNodeStreamWriter writer;
    private final int endNodeCount;

    private YangInstanceIdentifierWriter(NormalizedNodeStreamWriter writer, int endNodeCount) {
        this.writer = Objects.requireNonNull(writer);
        this.endNodeCount = endNodeCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static @NonNull YangInstanceIdentifierWriter open(NormalizedNodeStreamWriter writer, DataNodeContainer root, YangInstanceIdentifier path) throws IOException {
        Iterator<YangInstanceIdentifier.PathArgument> it = path.getPathArguments().iterator();
        if (!it.hasNext()) {
            return new YangInstanceIdentifierWriter(writer, 0);
        }
        int endNodes = 0;
        DataNodeContainer parent = root;
        boolean reuse = false;
        boolean terminal = false;
        do {
            ListSchemaNode list;
            YangInstanceIdentifier.AbstractPathArgument nodeId;
            if (terminal) {
                throw new IOException(parent + " is a terminal node, cannot resolve " + ImmutableList.copyOf(it));
            }
            YangInstanceIdentifier.PathArgument arg = it.next();
            if (arg instanceof YangInstanceIdentifier.AugmentationIdentifier) {
                if (!(parent instanceof AugmentationTarget)) {
                    throw new IOException(parent + " does not support augmentations, cannot resolve " + arg);
                }
                if (reuse) {
                    throw new IOException(parent + " is expecting a nested item, cannot resolve " + arg);
                }
                YangInstanceIdentifier.AugmentationIdentifier augId = (YangInstanceIdentifier.AugmentationIdentifier)arg;
                if (!(parent instanceof DataNodeContainer)) {
                    if (!(parent instanceof ChoiceSchemaNode)) throw new IOException("Unhandled parent " + parent + " while resolving " + arg);
                    throw new IOException(parent + " should not use addressing through " + arg);
                }
                parent = new EffectiveAugmentationSchema(YangInstanceIdentifierWriter.enterAugmentation((AugmentationTarget)parent, augId), parent);
                writer.startAugmentationNode(augId);
            } else if (arg instanceof YangInstanceIdentifier.NodeWithValue) {
                if (!(parent instanceof LeafListSchemaNode)) {
                    throw new IOException(parent + " does not support leaf-list entry " + arg);
                }
                if (!reuse) {
                    throw new IOException(parent + " is already at its entry, cannot enter " + arg);
                }
                reuse = false;
                terminal = true;
                writer.startLeafSetEntryNode((YangInstanceIdentifier.NodeWithValue)arg);
            } else if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                if (!(parent instanceof ListSchemaNode)) {
                    throw new IOException(parent + " does not support map entry " + arg);
                }
                if (!reuse) {
                    throw new IOException(parent + " is already at its entry, cannot enter " + arg);
                }
                nodeId = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
                list = (ListSchemaNode)parent;
                if (!list.getQName().equals((Object)nodeId.getNodeType())) {
                    throw new IOException(parent + " expects a matching map entry, cannot enter " + arg);
                }
                List key = list.getKeyDefinition();
                if (key.isEmpty()) {
                    throw new IOException(parent + " does not expect map entry " + arg);
                }
                if (key.size() != ((YangInstanceIdentifier.NodeIdentifierWithPredicates)nodeId).size()) {
                    throw new IOException(parent + " expects " + key.size() + " predicates, cannot use " + arg);
                }
                reuse = false;
                writer.startMapEntryNode(YangInstanceIdentifierWriter.normalizePredicates((YangInstanceIdentifier.NodeIdentifierWithPredicates)nodeId, key), 1);
            } else {
                DataSchemaNode child;
                if (!(arg instanceof YangInstanceIdentifier.NodeIdentifier)) throw new IOException("Unhandled argument " + arg);
                nodeId = (YangInstanceIdentifier.NodeIdentifier)arg;
                if (reuse) {
                    if (!(parent instanceof ListSchemaNode)) {
                        throw new IOException(parent + " expects an identifiable entry, cannot enter " + arg);
                    }
                    list = (ListSchemaNode)parent;
                    if (!list.getKeyDefinition().isEmpty()) {
                        throw new IOException(parent + " expects a map entry, cannot enter " + arg);
                    }
                    if (!list.getQName().equals((Object)nodeId.getNodeType())) {
                        throw new IOException(parent + " expects a matching entry, cannot enter " + arg);
                    }
                    reuse = false;
                    writer.startUnkeyedListItem((YangInstanceIdentifier.NodeIdentifier)nodeId, 1);
                    ++endNodes;
                    continue;
                }
                if (parent instanceof DataNodeContainer) {
                    child = parent.dataChildByName(nodeId.getNodeType());
                } else {
                    if (!(parent instanceof ChoiceSchemaNode)) throw new IOException("Unhandled parent " + parent + " when looking up " + arg);
                    child = ((ChoiceSchemaNode)parent).findDataSchemaChild(nodeId.getNodeType()).orElse(null);
                }
                if (child == null) {
                    throw new IOException("Failed to find child " + arg + " in parent " + parent);
                }
                if (child instanceof ContainerLike) {
                    parent = child;
                    writer.startContainerNode((YangInstanceIdentifier.NodeIdentifier)nodeId, 1);
                } else if (child instanceof ListSchemaNode) {
                    parent = child;
                    reuse = true;
                    ListSchemaNode list2 = (ListSchemaNode)child;
                    if (list2.getKeyDefinition().isEmpty()) {
                        writer.startUnkeyedList((YangInstanceIdentifier.NodeIdentifier)nodeId, 1);
                    } else if (list2.isUserOrdered()) {
                        writer.startOrderedMapNode((YangInstanceIdentifier.NodeIdentifier)nodeId, 1);
                    } else {
                        writer.startMapNode((YangInstanceIdentifier.NodeIdentifier)nodeId, 1);
                    }
                } else if (child instanceof LeafSchemaNode) {
                    parent = child;
                    terminal = true;
                    writer.startLeafNode((YangInstanceIdentifier.NodeIdentifier)nodeId);
                } else if (child instanceof ChoiceSchemaNode) {
                    parent = child;
                    writer.startChoiceNode((YangInstanceIdentifier.NodeIdentifier)nodeId, 1);
                } else if (child instanceof LeafListSchemaNode) {
                    parent = child;
                    reuse = true;
                    if (((LeafListSchemaNode)child).isUserOrdered()) {
                        writer.startOrderedLeafSet((YangInstanceIdentifier.NodeIdentifier)nodeId, 1);
                    } else {
                        writer.startLeafSet((YangInstanceIdentifier.NodeIdentifier)nodeId, 1);
                    }
                } else if (child instanceof AnydataSchemaNode) {
                    parent = child;
                    terminal = true;
                    writer.startAnydataNode((YangInstanceIdentifier.NodeIdentifier)nodeId, NormalizedAnydata.class);
                } else {
                    if (!(child instanceof AnyxmlSchemaNode)) throw new IOException("Unhandled child " + child);
                    parent = child;
                    terminal = true;
                    writer.startAnyxmlNode((YangInstanceIdentifier.NodeIdentifier)nodeId, DOMSource.class);
                }
            }
            ++endNodes;
        } while (it.hasNext());
        return new YangInstanceIdentifierWriter(writer, endNodes);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            for (int i = 0; i < this.endNodeCount; ++i) {
                this.writer.endNode();
            }
            this.writer = null;
        }
    }

    private static YangInstanceIdentifier.NodeIdentifierWithPredicates normalizePredicates(YangInstanceIdentifier.NodeIdentifierWithPredicates input, List<QName> key) throws IOException {
        if (Iterables.elementsEqual(input.keySet(), key)) {
            return input;
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)key.size());
        for (QName qname : key) {
            Object value = input.getValue(qname);
            if (value == null) {
                throw new IOException("Cannot normalize " + input + " to " + key + ", missing value for " + qname);
            }
            builder.put((Object)qname, value);
        }
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of(input.getNodeType(), ImmutableOffsetMap.orderedCopyOf((Map)builder.build()));
    }

    private static AugmentationSchemaNode enterAugmentation(AugmentationTarget target, YangInstanceIdentifier.AugmentationIdentifier id) throws IOException {
        Collection augs = target.getAvailableAugmentations();
        for (AugmentationSchemaNode augment : augs) {
            if (!id.equals(YangInstanceIdentifierWriter.augmentationIdentifierFrom(augment))) continue;
            return augment;
        }
        throw new IOException("Cannot find augmentation " + id + " in " + target + ", available: " + Collections2.transform((Collection)augs, YangInstanceIdentifierWriter::augmentationIdentifierFrom));
    }

    static @NonNull YangInstanceIdentifier.AugmentationIdentifier augmentationIdentifierFrom(AugmentationSchemaNode schema) {
        return new YangInstanceIdentifier.AugmentationIdentifier((ImmutableSet<QName>)((ImmutableSet)schema.getChildNodes().stream().map(SchemaNode::getQName).collect(ImmutableSet.toImmutableSet())));
    }
}

