/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.base.Strings;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.opendaylight.controller.blueprint.ext.BindingContext;
import org.opendaylight.controller.blueprint.ext.ConfigXMLReaderException;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaTreeInference;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DataStoreAppConfigDefaultXMLReader<T extends DataObject> {
    private static final Logger LOG = LoggerFactory.getLogger(DataStoreAppConfigDefaultXMLReader.class);
    private final String logName;
    private final String defaultAppConfigFileName;
    private final DOMSchemaService schemaService;
    private final BindingNormalizedNodeSerializer bindingSerializer;
    private final BindingContext bindingContext;
    private final ConfigURLProvider inputStreamProvider;

    public DataStoreAppConfigDefaultXMLReader(String logName, String defaultAppConfigFileName, DOMSchemaService schemaService, BindingNormalizedNodeSerializer bindingSerializer, BindingContext bindingContext, ConfigURLProvider inputStreamProvider) {
        this.logName = logName;
        this.defaultAppConfigFileName = defaultAppConfigFileName;
        this.schemaService = schemaService;
        this.bindingSerializer = bindingSerializer;
        this.bindingContext = bindingContext;
        this.inputStreamProvider = inputStreamProvider;
    }

    public DataStoreAppConfigDefaultXMLReader(Class<?> testClass, String defaultAppConfigFileName, DOMSchemaService schemaService, BindingNormalizedNodeSerializer bindingSerializer, Class<T> klass) {
        this(testClass.getName(), defaultAppConfigFileName, schemaService, bindingSerializer, BindingContext.create(testClass.getName(), klass, null), appConfigFileName -> Optional.of(DataStoreAppConfigDefaultXMLReader.getURL(testClass, defaultAppConfigFileName)));
    }

    private static URL getURL(Class<?> testClass, String defaultAppConfigFileName) {
        return Resources.getResource(testClass, (String)defaultAppConfigFileName);
    }

    public T createDefaultInstance() throws ConfigXMLReaderException, ParserConfigurationException, XMLStreamException, IOException, SAXException, URISyntaxException {
        return this.createDefaultInstance(dataSchema -> {
            throw new IllegalArgumentException("Failed to read XML (not creating model from defaults as runtime would, for better clarity in tests)");
        });
    }

    public T createDefaultInstance(FallbackConfigProvider fallback) throws ConfigXMLReaderException, URISyntaxException, ParserConfigurationException, XMLStreamException, SAXException, IOException {
        SchemaTreeEffectiveStatement dataSchema;
        YangInstanceIdentifier yangPath = this.bindingSerializer.toYangInstanceIdentifier(this.bindingContext.appConfigPath);
        LOG.debug("{}: Creating app config instance from path {}, Qname: {}", new Object[]{this.logName, yangPath, this.bindingContext.bindingQName});
        DataStoreAppConfigDefaultXMLReader.checkNotNull(this.schemaService, "%s: Could not obtain the SchemaService OSGi service", this.logName);
        EffectiveModelContext schemaContext = this.schemaService.getGlobalContext();
        Module module = schemaContext.findModule(this.bindingContext.bindingQName.getModule()).orElse(null);
        DataStoreAppConfigDefaultXMLReader.checkNotNull(module, "%s: Could not obtain the module schema for namespace %s, revision %s", this.logName, this.bindingContext.bindingQName.getNamespace(), this.bindingContext.bindingQName.getRevision());
        SchemaInferenceStack schemaStack = SchemaInferenceStack.of((EffectiveModelContext)schemaContext);
        try {
            dataSchema = schemaStack.enterSchemaTree(this.bindingContext.bindingQName);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigXMLReaderException(this.logName + ": Could not obtain the schema for " + this.bindingContext.bindingQName, e);
        }
        DataStoreAppConfigDefaultXMLReader.checkCondition(this.bindingContext.schemaType.isInstance(dataSchema), "%s: Expected schema type %s for %s but actual type is %s", this.logName, this.bindingContext.schemaType, this.bindingContext.bindingQName, dataSchema.getClass());
        NormalizedNode dataNode = this.parsePossibleDefaultAppConfigXMLFile(schemaStack);
        if (dataNode == null) {
            dataNode = fallback.get(schemaStack.toSchemaTreeInference());
        }
        DataObject appConfig = (DataObject)this.bindingSerializer.fromNormalizedNode(yangPath, dataNode).getValue();
        DataStoreAppConfigDefaultXMLReader.checkNotNull(appConfig, "%s: Could not create instance for app config binding %s", this.logName, this.bindingContext.appConfigBindingClass);
        return (T)appConfig;
    }

    private static void checkNotNull(Object reference, String errorMessageFormat, Object ... formatArgs) throws ConfigXMLReaderException {
        DataStoreAppConfigDefaultXMLReader.checkCondition(reference != null, errorMessageFormat, formatArgs);
    }

    private static void checkCondition(boolean expression, String errorMessageFormat, Object ... formatArgs) throws ConfigXMLReaderException {
        if (!expression) {
            throw new ConfigXMLReaderException(String.format(errorMessageFormat, formatArgs));
        }
    }

    private NormalizedNode parsePossibleDefaultAppConfigXMLFile(SchemaInferenceStack schemaStack) throws ConfigXMLReaderException {
        NormalizedNode normalizedNode;
        block12: {
            Optional<URL> optionalURL;
            Object appConfigFileName = this.defaultAppConfigFileName;
            if (Strings.isNullOrEmpty((String)appConfigFileName)) {
                String moduleName = ((UnresolvedQName.Unqualified)schemaStack.currentModule().argument()).getLocalName();
                appConfigFileName = moduleName + "_" + this.bindingContext.bindingQName.getLocalName() + ".xml";
            }
            try {
                optionalURL = this.inputStreamProvider.getURL((String)appConfigFileName);
            }
            catch (IOException e) {
                String msg = String.format("%s: Could not getURL()", this.logName);
                LOG.error(msg, (Throwable)e);
                throw new ConfigXMLReaderException(msg, e);
            }
            if (!optionalURL.isPresent()) {
                return null;
            }
            URL url = optionalURL.get();
            InputStream is = url.openStream();
            try {
                Document root = UntrustedXML.newDocumentBuilder().parse(is);
                NormalizedNode dataNode = this.bindingContext.parseDataElement(root.getDocumentElement(), schemaStack.toSchemaTreeInference());
                LOG.debug("{}: Parsed data node: {}", (Object)this.logName, (Object)dataNode);
                normalizedNode = dataNode;
                if (is == null) break block12;
            }
            catch (Throwable root) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            root.addSuppressed(throwable);
                        }
                    }
                    throw root;
                }
                catch (IOException | URISyntaxException | ParserConfigurationException | XMLStreamException | SAXException e) {
                    String msg = String.format("%s: Could not read/parse app config %s", this.logName, url);
                    LOG.error(msg, (Throwable)e);
                    throw new ConfigXMLReaderException(msg, e);
                }
            }
            is.close();
        }
        return normalizedNode;
    }

    @FunctionalInterface
    public static interface ConfigURLProvider {
        public Optional<URL> getURL(String var1) throws IOException;
    }

    @FunctionalInterface
    public static interface FallbackConfigProvider {
        public NormalizedNode get(SchemaTreeInference var1) throws IOException, XMLStreamException, ParserConfigurationException, SAXException, URISyntaxException;
    }
}

