/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceReferenceMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.opendaylight.controller.blueprint.BlueprintContainerRestartService;
import org.opendaylight.controller.blueprint.ext.ActionProviderBean;
import org.opendaylight.controller.blueprint.ext.ActionServiceMetadata;
import org.opendaylight.controller.blueprint.ext.ComponentProcessor;
import org.opendaylight.controller.blueprint.ext.DataStoreAppConfigMetadata;
import org.opendaylight.controller.blueprint.ext.NotificationListenerBean;
import org.opendaylight.controller.blueprint.ext.RpcImplementationBean;
import org.opendaylight.controller.blueprint.ext.RpcServiceMetadata;
import org.opendaylight.controller.blueprint.ext.SpecificReferenceListMetadata;
import org.opendaylight.controller.blueprint.ext.StaticReferenceMetadata;
import org.opendaylight.controller.blueprint.ext.UpdateStrategy;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class OpendaylightNamespaceHandler
implements NamespaceHandler {
    public static final String NAMESPACE_1_0_0 = "http://opendaylight.org/xmlns/blueprint/v1.0.0";
    static final String ROUTED_RPC_REG_CONVERTER_NAME = "org.opendaylight.blueprint.RoutedRpcRegConverter";
    static final String DOM_RPC_PROVIDER_SERVICE_NAME = "org.opendaylight.blueprint.DOMRpcProviderService";
    static final String RPC_REGISTRY_NAME = "org.opendaylight.blueprint.RpcRegistry";
    static final String BINDING_RPC_PROVIDER_SERVICE_NAME = "org.opendaylight.blueprint.RpcProviderService";
    static final String SCHEMA_SERVICE_NAME = "org.opendaylight.blueprint.SchemaService";
    static final String NOTIFICATION_SERVICE_NAME = "org.opendaylight.blueprint.NotificationService";
    static final String TYPE_ATTR = "type";
    static final String UPDATE_STRATEGY_ATTR = "update-strategy";
    private static final Logger LOG = LoggerFactory.getLogger(OpendaylightNamespaceHandler.class);
    private static final String COMPONENT_PROCESSOR_NAME = ComponentProcessor.class.getName();
    private static final String RESTART_DEPENDENTS_ON_UPDATES = "restart-dependents-on-updates";
    private static final String USE_DEFAULT_FOR_REFERENCE_TYPES = "use-default-for-reference-types";
    private static final String CLUSTERED_APP_CONFIG = "clustered-app-config";
    private static final String INTERFACE = "interface";
    private static final String REF_ATTR = "ref";
    private static final String ID_ATTR = "id";
    private static final String RPC_SERVICE = "rpc-service";
    private static final String ACTION_SERVICE = "action-service";
    private static final String SPECIFIC_SERVICE_REF_LIST = "specific-reference-list";
    private static final String STATIC_REFERENCE = "static-reference";

    public Set<Class> getManagedClasses() {
        return Collections.emptySet();
    }

    public URL getSchemaLocation(String namespace) {
        if (NAMESPACE_1_0_0.equals(namespace)) {
            URL url = this.getClass().getResource("/opendaylight-blueprint-ext-1.0.0.xsd");
            LOG.debug("getSchemaLocation for {} returning URL {}", (Object)namespace, (Object)url);
            return url;
        }
        return null;
    }

    public Metadata parse(Element element, ParserContext context) {
        LOG.debug("In parse for {}", (Object)element);
        if (OpendaylightNamespaceHandler.nodeNameEquals(element, "rpc-implementation")) {
            return OpendaylightNamespaceHandler.parseRpcImplementation(element, context);
        }
        if (OpendaylightNamespaceHandler.nodeNameEquals(element, RPC_SERVICE)) {
            return OpendaylightNamespaceHandler.parseRpcService(element, context);
        }
        if (OpendaylightNamespaceHandler.nodeNameEquals(element, "notification-listener")) {
            return OpendaylightNamespaceHandler.parseNotificationListener(element, context);
        }
        if (OpendaylightNamespaceHandler.nodeNameEquals(element, CLUSTERED_APP_CONFIG)) {
            return OpendaylightNamespaceHandler.parseClusteredAppConfig(element, context);
        }
        if (OpendaylightNamespaceHandler.nodeNameEquals(element, SPECIFIC_SERVICE_REF_LIST)) {
            return OpendaylightNamespaceHandler.parseSpecificReferenceList(element, context);
        }
        if (OpendaylightNamespaceHandler.nodeNameEquals(element, STATIC_REFERENCE)) {
            return OpendaylightNamespaceHandler.parseStaticReference(element, context);
        }
        if (OpendaylightNamespaceHandler.nodeNameEquals(element, ACTION_SERVICE)) {
            return OpendaylightNamespaceHandler.parseActionService(element, context);
        }
        if (OpendaylightNamespaceHandler.nodeNameEquals(element, "action-provider")) {
            return OpendaylightNamespaceHandler.parseActionProvider(element, context);
        }
        throw new ComponentDefinitionException("Unsupported standalone element: " + element.getNodeName());
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        if (node instanceof Attr) {
            if (OpendaylightNamespaceHandler.nodeNameEquals(node, RESTART_DEPENDENTS_ON_UPDATES)) {
                return OpendaylightNamespaceHandler.decorateRestartDependentsOnUpdates((Attr)node, component, context);
            }
            if (OpendaylightNamespaceHandler.nodeNameEquals(node, USE_DEFAULT_FOR_REFERENCE_TYPES)) {
                return OpendaylightNamespaceHandler.decorateUseDefaultForReferenceTypes((Attr)node, component, context);
            }
            if (OpendaylightNamespaceHandler.nodeNameEquals(node, TYPE_ATTR)) {
                if (component instanceof ServiceReferenceMetadata) {
                    return OpendaylightNamespaceHandler.decorateServiceReferenceType((Attr)node, component, context);
                }
                if (component instanceof ServiceMetadata) {
                    return OpendaylightNamespaceHandler.decorateServiceType((Attr)node, component, context);
                }
                throw new ComponentDefinitionException("Attribute " + node.getNodeName() + " can only be used on a <reference>, <reference-list> or <service> element");
            }
            throw new ComponentDefinitionException("Unsupported attribute: " + node.getNodeName());
        }
        throw new ComponentDefinitionException("Unsupported node type: " + node);
    }

    private static ComponentMetadata decorateServiceType(Attr attr, ComponentMetadata component, ParserContext context) {
        if (!(component instanceof MutableServiceMetadata)) {
            throw new ComponentDefinitionException("Expected an instanceof MutableServiceMetadata");
        }
        MutableServiceMetadata service = (MutableServiceMetadata)component;
        LOG.debug("decorateServiceType for {} - adding type property {}", (Object)service.getId(), (Object)attr.getValue());
        service.addServiceProperty((NonNullMetadata)OpendaylightNamespaceHandler.createValue(context, TYPE_ATTR), (Metadata)OpendaylightNamespaceHandler.createValue(context, attr.getValue()));
        return component;
    }

    private static ComponentMetadata decorateServiceReferenceType(Attr attr, ComponentMetadata component, ParserContext context) {
        if (!(component instanceof MutableServiceReferenceMetadata)) {
            throw new ComponentDefinitionException("Expected an instanceof MutableServiceReferenceMetadata");
        }
        OpendaylightNamespaceHandler.registerComponentProcessor(context);
        MutableServiceReferenceMetadata serviceRef = (MutableServiceReferenceMetadata)component;
        String oldFilter = serviceRef.getExtendedFilter() == null ? null : serviceRef.getExtendedFilter().getStringValue();
        String filter = Strings.isNullOrEmpty((String)oldFilter) ? String.format("(type=%s)", attr.getValue()) : String.format("(&(%s)(type=%s))", oldFilter, attr.getValue());
        LOG.debug("decorateServiceReferenceType for {} with type {}, old filter: {}, new filter: {}", new Object[]{serviceRef.getId(), attr.getValue(), oldFilter, filter});
        serviceRef.setExtendedFilter(OpendaylightNamespaceHandler.createValue(context, filter));
        return component;
    }

    private static ComponentMetadata decorateRestartDependentsOnUpdates(Attr attr, ComponentMetadata component, ParserContext context) {
        return OpendaylightNamespaceHandler.enableComponentProcessorProperty(attr, component, context, "restartDependentsOnUpdates");
    }

    private static ComponentMetadata decorateUseDefaultForReferenceTypes(Attr attr, ComponentMetadata component, ParserContext context) {
        return OpendaylightNamespaceHandler.enableComponentProcessorProperty(attr, component, context, "useDefaultForReferenceTypes");
    }

    private static ComponentMetadata enableComponentProcessorProperty(Attr attr, ComponentMetadata component, ParserContext context, String propertyName) {
        if (component != null) {
            throw new ComponentDefinitionException("Attribute " + attr.getNodeName() + " can only be used on the root <blueprint> element");
        }
        LOG.debug("Property {} = {}", (Object)propertyName, (Object)attr.getValue());
        if (!Boolean.parseBoolean(attr.getValue())) {
            return component;
        }
        MutableBeanMetadata metadata = OpendaylightNamespaceHandler.registerComponentProcessor(context);
        metadata.addProperty(propertyName, (Metadata)OpendaylightNamespaceHandler.createValue(context, "true"));
        return component;
    }

    private static MutableBeanMetadata registerComponentProcessor(ParserContext context) {
        ComponentDefinitionRegistry registry = context.getComponentDefinitionRegistry();
        MutableBeanMetadata metadata = (MutableBeanMetadata)registry.getComponentDefinition(COMPONENT_PROCESSOR_NAME);
        if (metadata == null) {
            metadata = OpendaylightNamespaceHandler.createBeanMetadata(context, COMPONENT_PROCESSOR_NAME, ComponentProcessor.class, false, true);
            metadata.setProcessor(true);
            OpendaylightNamespaceHandler.addBlueprintBundleRefProperty(context, metadata);
            metadata.addProperty("blueprintContainerRestartService", (Metadata)OpendaylightNamespaceHandler.createServiceRef(context, BlueprintContainerRestartService.class, null));
            LOG.debug("Registering ComponentProcessor bean: {}", (Object)metadata);
            registry.registerComponentDefinition((ComponentMetadata)metadata);
        }
        return metadata;
    }

    private static Metadata parseActionProvider(Element element, ParserContext context) {
        OpendaylightNamespaceHandler.registerDomRpcProviderServiceRefBean(context);
        OpendaylightNamespaceHandler.registerBindingRpcProviderServiceRefBean(context);
        OpendaylightNamespaceHandler.registerSchemaServiceRefBean(context);
        MutableBeanMetadata metadata = OpendaylightNamespaceHandler.createBeanMetadata(context, context.generateId(), ActionProviderBean.class, true, true);
        OpendaylightNamespaceHandler.addBlueprintBundleRefProperty(context, metadata);
        metadata.addProperty("domRpcProvider", (Metadata)OpendaylightNamespaceHandler.createRef(context, DOM_RPC_PROVIDER_SERVICE_NAME));
        metadata.addProperty("bindingRpcProvider", (Metadata)OpendaylightNamespaceHandler.createRef(context, BINDING_RPC_PROVIDER_SERVICE_NAME));
        metadata.addProperty("schemaService", (Metadata)OpendaylightNamespaceHandler.createRef(context, SCHEMA_SERVICE_NAME));
        metadata.addProperty("interfaceName", (Metadata)OpendaylightNamespaceHandler.createValue(context, element.getAttribute(INTERFACE)));
        if (element.hasAttribute(REF_ATTR)) {
            metadata.addProperty("implementation", (Metadata)OpendaylightNamespaceHandler.createRef(context, element.getAttribute(REF_ATTR)));
        }
        LOG.debug("parseActionProvider returning {}", (Object)metadata);
        return metadata;
    }

    private static Metadata parseRpcImplementation(Element element, ParserContext context) {
        OpendaylightNamespaceHandler.registerBindingRpcProviderServiceRefBean(context);
        MutableBeanMetadata metadata = OpendaylightNamespaceHandler.createBeanMetadata(context, context.generateId(), RpcImplementationBean.class, true, true);
        OpendaylightNamespaceHandler.addBlueprintBundleRefProperty(context, metadata);
        metadata.addProperty("rpcProvider", (Metadata)OpendaylightNamespaceHandler.createRef(context, BINDING_RPC_PROVIDER_SERVICE_NAME));
        metadata.addProperty("implementation", (Metadata)OpendaylightNamespaceHandler.createRef(context, element.getAttribute(REF_ATTR)));
        if (element.hasAttribute(INTERFACE)) {
            metadata.addProperty("interfaceName", (Metadata)OpendaylightNamespaceHandler.createValue(context, element.getAttribute(INTERFACE)));
        }
        LOG.debug("parseRpcImplementation returning {}", (Object)metadata);
        return metadata;
    }

    private static Metadata parseActionService(Element element, ParserContext context) {
        ActionServiceMetadata metadata = new ActionServiceMetadata(OpendaylightNamespaceHandler.getId(context, element), element.getAttribute(INTERFACE));
        LOG.debug("parseActionService returning {}", (Object)metadata);
        return metadata;
    }

    private static Metadata parseRpcService(Element element, ParserContext context) {
        RpcServiceMetadata metadata = new RpcServiceMetadata(OpendaylightNamespaceHandler.getId(context, element), element.getAttribute(INTERFACE));
        LOG.debug("parseRpcService returning {}", (Object)metadata);
        return metadata;
    }

    private static void registerDomRpcProviderServiceRefBean(ParserContext context) {
        OpendaylightNamespaceHandler.registerRefBean(context, DOM_RPC_PROVIDER_SERVICE_NAME, DOMRpcProviderService.class);
    }

    private static void registerBindingRpcProviderServiceRefBean(ParserContext context) {
        OpendaylightNamespaceHandler.registerRefBean(context, BINDING_RPC_PROVIDER_SERVICE_NAME, RpcProviderService.class);
    }

    private static void registerSchemaServiceRefBean(ParserContext context) {
        OpendaylightNamespaceHandler.registerRefBean(context, SCHEMA_SERVICE_NAME, DOMSchemaService.class);
    }

    private static void registerRefBean(ParserContext context, String name, Class<?> clazz) {
        ComponentDefinitionRegistry registry = context.getComponentDefinitionRegistry();
        if (registry.getComponentDefinition(name) == null) {
            MutableReferenceMetadata metadata = OpendaylightNamespaceHandler.createServiceRef(context, clazz, null);
            metadata.setId(name);
            registry.registerComponentDefinition((ComponentMetadata)metadata);
        }
    }

    private static Metadata parseNotificationListener(Element element, ParserContext context) {
        OpendaylightNamespaceHandler.registerNotificationServiceRefBean(context);
        MutableBeanMetadata metadata = OpendaylightNamespaceHandler.createBeanMetadata(context, context.generateId(), NotificationListenerBean.class, true, true);
        OpendaylightNamespaceHandler.addBlueprintBundleRefProperty(context, metadata);
        metadata.addProperty("notificationService", (Metadata)OpendaylightNamespaceHandler.createRef(context, NOTIFICATION_SERVICE_NAME));
        metadata.addProperty("notificationListener", (Metadata)OpendaylightNamespaceHandler.createRef(context, element.getAttribute(REF_ATTR)));
        LOG.debug("parseNotificationListener returning {}", (Object)metadata);
        return metadata;
    }

    private static void registerNotificationServiceRefBean(ParserContext context) {
        ComponentDefinitionRegistry registry = context.getComponentDefinitionRegistry();
        if (registry.getComponentDefinition(NOTIFICATION_SERVICE_NAME) == null) {
            MutableReferenceMetadata metadata = OpendaylightNamespaceHandler.createServiceRef(context, NotificationService.class, null);
            metadata.setId(NOTIFICATION_SERVICE_NAME);
            registry.registerComponentDefinition((ComponentMetadata)metadata);
        }
    }

    private static Metadata parseClusteredAppConfig(Element element, ParserContext context) {
        LOG.debug("parseClusteredAppConfig");
        Node defaultConfigElement = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!OpendaylightNamespaceHandler.nodeNameEquals(child, "default-config")) continue;
            defaultConfigElement = (Element)child;
            break;
        }
        Element defaultAppConfigElement = null;
        if (defaultConfigElement != null) {
            children = defaultConfigElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 4) continue;
                defaultAppConfigElement = OpendaylightNamespaceHandler.parseXML("default-config", child.getTextContent());
                break;
            }
        }
        return new DataStoreAppConfigMetadata(OpendaylightNamespaceHandler.getId(context, element), element.getAttribute("binding-class"), element.getAttribute("list-key-value"), element.getAttribute("default-config-file-name"), OpendaylightNamespaceHandler.parseUpdateStrategy(element.getAttribute(UPDATE_STRATEGY_ATTR)), defaultAppConfigElement);
    }

    private static UpdateStrategy parseUpdateStrategy(String updateStrategyValue) {
        if (Strings.isNullOrEmpty((String)updateStrategyValue) || updateStrategyValue.equalsIgnoreCase(UpdateStrategy.RELOAD.name())) {
            return UpdateStrategy.RELOAD;
        }
        if (updateStrategyValue.equalsIgnoreCase(UpdateStrategy.NONE.name())) {
            return UpdateStrategy.NONE;
        }
        LOG.warn("update-strategy {} not supported, using reload", (Object)updateStrategyValue);
        return UpdateStrategy.RELOAD;
    }

    private static Metadata parseSpecificReferenceList(Element element, ParserContext context) {
        SpecificReferenceListMetadata metadata = new SpecificReferenceListMetadata(OpendaylightNamespaceHandler.getId(context, element), element.getAttribute(INTERFACE));
        LOG.debug("parseSpecificReferenceList returning {}", (Object)metadata);
        return metadata;
    }

    private static Metadata parseStaticReference(Element element, ParserContext context) {
        StaticReferenceMetadata metadata = new StaticReferenceMetadata(OpendaylightNamespaceHandler.getId(context, element), element.getAttribute(INTERFACE));
        LOG.debug("parseStaticReference returning {}", (Object)metadata);
        return metadata;
    }

    private static Element parseXML(String name, String xml) {
        try {
            return UntrustedXML.newDocumentBuilder().parse(new InputSource(new StringReader(xml))).getDocumentElement();
        }
        catch (IOException | SAXException e) {
            throw new ComponentDefinitionException(String.format("Error %s parsing XML: %s", name, xml), (Throwable)e);
        }
    }

    private static ValueMetadata createValue(ParserContext context, String value) {
        MutableValueMetadata metadata = (MutableValueMetadata)context.createMetadata(MutableValueMetadata.class);
        metadata.setStringValue(value);
        return metadata;
    }

    private static MutableReferenceMetadata createServiceRef(ParserContext context, Class<?> cls, String filter) {
        MutableReferenceMetadata metadata = (MutableReferenceMetadata)context.createMetadata(MutableReferenceMetadata.class);
        metadata.setRuntimeInterface(cls);
        metadata.setInterface(cls.getName());
        metadata.setActivation(1);
        metadata.setAvailability(1);
        if (filter != null) {
            metadata.setFilter(filter);
        }
        return metadata;
    }

    private static RefMetadata createRef(ParserContext context, String id) {
        MutableRefMetadata metadata = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
        metadata.setComponentId(id);
        return metadata;
    }

    private static String getId(ParserContext context, Element element) {
        if (element.hasAttribute(ID_ATTR)) {
            return element.getAttribute(ID_ATTR);
        }
        return context.generateId();
    }

    private static boolean nodeNameEquals(Node node, String name) {
        return name.equals(node.getNodeName()) || name.equals(node.getLocalName());
    }

    private static void addBlueprintBundleRefProperty(ParserContext context, MutableBeanMetadata metadata) {
        metadata.addProperty("bundle", (Metadata)OpendaylightNamespaceHandler.createRef(context, "blueprintBundle"));
    }

    private static MutableBeanMetadata createBeanMetadata(ParserContext context, String id, Class<?> runtimeClass, boolean initMethod, boolean destroyMethod) {
        MutableBeanMetadata metadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        metadata.setId(id);
        metadata.setScope("singleton");
        metadata.setActivation(1);
        metadata.setRuntimeClass(runtimeClass);
        if (initMethod) {
            metadata.setInitMethod("init");
        }
        if (destroyMethod) {
            metadata.setDestroyMethod("destroy");
        }
        return metadata;
    }
}

