/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.osgi.impl;

import org.apache.karaf.features.FeaturesService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.dom.schema.osgi.impl.KarafYangModuleInfoRegistry;
import org.opendaylight.mdsal.dom.schema.osgi.impl.RegularYangModuleInfoRegistry;
import org.opendaylight.mdsal.dom.schema.osgi.impl.YangModuleInfoRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
final class KarafFeaturesSupport {
    private static final Logger LOG = LoggerFactory.getLogger(KarafFeaturesSupport.class);
    private static final WrapperFunction WRAPPER = KarafFeaturesSupport.staticInit();

    private KarafFeaturesSupport() {
    }

    static YangModuleInfoRegistry wrap(BundleContext ctx, RegularYangModuleInfoRegistry regular) {
        return WRAPPER.wrap(ctx, regular);
    }

    private static WrapperFunction staticInit() {
        try {
            KarafWrapperFunction karaf = new KarafWrapperFunction();
            LOG.info("Will attempt to integrate with Karaf FeaturesService");
            return karaf;
        }
        catch (NoClassDefFoundError e) {
            LOG.trace("Failed to initialize Karaf support", (Throwable)e);
            LOG.info("Karaf FeaturesService integration disabled");
            return new NoopWrapperFunction();
        }
    }

    private static final class KarafWrapperFunction
    implements WrapperFunction {
        private static final Class<FeaturesService> FEATURES_SERVICE = FeaturesService.class;

        private KarafWrapperFunction() {
        }

        @Override
        public YangModuleInfoRegistry wrap(BundleContext ctx, RegularYangModuleInfoRegistry delegate) {
            FeaturesService features;
            ServiceReference ref = ctx.getServiceReference(FEATURES_SERVICE);
            if (ref != null && (features = (FeaturesService)ctx.getService(ref)) != null) {
                LOG.debug("Integrating with Karaf's FeaturesService");
                return KarafYangModuleInfoRegistry.create(features, delegate);
            }
            return delegate;
        }
    }

    private static final class NoopWrapperFunction
    implements WrapperFunction {
        private NoopWrapperFunction() {
        }

        @Override
        public YangModuleInfoRegistry wrap(BundleContext ctx, RegularYangModuleInfoRegistry delegate) {
            return delegate;
        }
    }

    @FunctionalInterface
    private static interface WrapperFunction {
        public YangModuleInfoRegistry wrap(BundleContext var1, RegularYangModuleInfoRegistry var2);
    }
}

