/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.akka.segjournal;

import akka.actor.ActorSystem;
import akka.persistence.AtomicWrite;
import akka.persistence.PersistentRepr;
import com.codahale.metrics.Histogram;
import com.google.common.base.Verify;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.SegmentedJournal;
import io.atomix.storage.journal.SegmentedJournalReader;
import io.atomix.storage.journal.SegmentedJournalWriter;
import io.atomix.utils.serializer.Namespace;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.opendaylight.controller.akka.segjournal.DataJournal;
import org.opendaylight.controller.akka.segjournal.DataJournalEntry;
import org.opendaylight.controller.akka.segjournal.DataJournalEntrySerializer;
import org.opendaylight.controller.akka.segjournal.SegmentedJournalActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;

final class DataJournalV0
extends DataJournal {
    private static final Logger LOG = LoggerFactory.getLogger(DataJournalV0.class);
    private final SegmentedJournal<DataJournalEntry> entries;

    DataJournalV0(String persistenceId, Histogram messageSize, ActorSystem system, StorageLevel storage, File directory, int maxEntrySize, int maxSegmentSize) {
        super(persistenceId, messageSize);
        this.entries = SegmentedJournal.builder().withStorageLevel(storage).withDirectory(directory).withName("data").withNamespace(Namespace.builder().register(new DataJournalEntrySerializer(system), DataJournalEntry.FromPersistence.class, DataJournalEntry.ToPersistence.class).build()).withMaxEntrySize(maxEntrySize).withMaxSegmentSize(maxSegmentSize).build();
    }

    @Override
    long lastWrittenSequenceNr() {
        return ((SegmentedJournalWriter)this.entries.writer()).getLastIndex();
    }

    @Override
    void deleteTo(long sequenceNr) {
        ((SegmentedJournalWriter)this.entries.writer()).commit(sequenceNr);
    }

    @Override
    void compactTo(long sequenceNr) {
        this.entries.compact(sequenceNr + 1L);
    }

    @Override
    void close() {
        this.entries.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleReplayMessages(SegmentedJournalActor.ReplayMessages message, long fromSequenceNr) {
        try (JournalReader reader = this.entries.openReader(fromSequenceNr);){
            Object next;
            int count = 0;
            while (((SegmentedJournalReader)reader).hasNext() && (long)count < message.max && ((Indexed)(next = ((SegmentedJournalReader)reader).next())).index() <= message.toSequenceNr) {
                LOG.trace("{}: replay {}", (Object)this.persistenceId, next);
                this.updateLargestSize(((Indexed)next).size());
                DataJournalEntry entry = (DataJournalEntry)((Indexed)next).entry();
                Verify.verify((boolean)(entry instanceof DataJournalEntry.FromPersistence), (String)"Unexpected entry %s", (Object)entry);
                PersistentRepr repr = ((DataJournalEntry.FromPersistence)entry).toRepr(this.persistenceId, ((Indexed)next).index());
                LOG.debug("{}: replaying {}", (Object)this.persistenceId, (Object)repr);
                message.replayCallback.accept(repr);
                ++count;
            }
            LOG.debug("{}: successfully replayed {} entries", (Object)this.persistenceId, (Object)count);
        }
        catch (Exception e) {
            LOG.warn("{}: failed to replay messages for {}", new Object[]{this.persistenceId, message, e});
            message.promise.failure((Throwable)e);
        }
        finally {
            message.promise.success(null);
        }
    }

    @Override
    long handleWriteMessages(SegmentedJournalActor.WriteMessages message) {
        int count = message.size();
        JournalWriter writer = this.entries.writer();
        long bytes = 0L;
        for (int i = 0; i < count; ++i) {
            long mark = ((SegmentedJournalWriter)writer).getLastIndex();
            AtomicWrite request = message.getRequest(i);
            List reprs = CollectionConverters.asJava((Seq)request.payload());
            LOG.trace("{}: append {}/{}: {} items at mark {}", new Object[]{this.persistenceId, i, count, reprs.size(), mark});
            try {
                bytes += this.writePayload((SegmentedJournalWriter<DataJournalEntry>)writer, reprs);
            }
            catch (Exception e) {
                LOG.warn("{}: failed to write out request {}/{} reverting to {}", new Object[]{this.persistenceId, i, count, mark, e});
                message.setFailure(i, e);
                ((SegmentedJournalWriter)writer).truncate(mark);
                continue;
            }
            message.setSuccess(i);
        }
        ((SegmentedJournalWriter)writer).flush();
        return bytes;
    }

    private long writePayload(SegmentedJournalWriter<DataJournalEntry> writer, List<PersistentRepr> reprs) {
        long bytes = 0L;
        for (PersistentRepr repr : reprs) {
            Object payload = repr.payload();
            if (!(payload instanceof Serializable)) {
                throw new UnsupportedOperationException("Non-serializable payload encountered " + payload.getClass());
            }
            LOG.trace("{}: starting append of {}", (Object)this.persistenceId, payload);
            Indexed<DataJournalEntry.ToPersistence> entry = writer.append(new DataJournalEntry.ToPersistence(repr));
            int size = entry.size();
            LOG.trace("{}: finished append of {} with {} bytes at {}", new Object[]{this.persistenceId, payload, size, entry.index()});
            this.recordMessageSize(size);
            bytes += (long)size;
        }
        return bytes;
    }
}

