/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry;

import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.Props;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.controller.remote.rpc.RemoteOpsProviderConfig;
import org.opendaylight.controller.remote.rpc.registry.RoutingTable;
import org.opendaylight.controller.remote.rpc.registry.gossip.Bucket;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreAccess;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreActor;
import org.opendaylight.controller.remote.rpc.registry.mbeans.RemoteRpcRegistryMXBeanImpl;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import scala.concurrent.ExecutionContext;

public class RpcRegistry
extends BucketStoreActor<RoutingTable> {
    private final ActorRef rpcRegistrar;
    private RemoteRpcRegistryMXBeanImpl mxBean;

    public RpcRegistry(RemoteOpsProviderConfig config, ActorRef rpcInvoker, ActorRef rpcRegistrar) {
        super(config, config.getRpcRegistryPersistenceId(), new RoutingTable(rpcInvoker, (Collection<DOMRpcIdentifier>)ImmutableSet.of()));
        this.rpcRegistrar = Objects.requireNonNull(rpcRegistrar);
    }

    public static Props props(RemoteOpsProviderConfig config, ActorRef rpcInvoker, ActorRef rpcRegistrar) {
        return Props.create(RpcRegistry.class, (Object[])new Object[]{config, rpcInvoker, rpcRegistrar});
    }

    @Override
    public void preStart() {
        super.preStart();
        this.mxBean = new RemoteRpcRegistryMXBeanImpl(new BucketStoreAccess(this.self(), (ExecutionContext)this.getContext().dispatcher(), this.getConfig().getAskDuration()), this.getConfig().getAskDuration());
    }

    public void postStop() throws Exception {
        if (this.mxBean != null) {
            this.mxBean.unregister();
            this.mxBean = null;
        }
        super.postStop();
    }

    @Override
    protected void handleCommand(Object message) throws Exception {
        if (message instanceof Messages.AddOrUpdateRoutes) {
            Messages.AddOrUpdateRoutes addRoutes = (Messages.AddOrUpdateRoutes)message;
            this.receiveAddRoutes(addRoutes);
        } else if (message instanceof Messages.RemoveRoutes) {
            Messages.RemoveRoutes removeRoutes = (Messages.RemoveRoutes)message;
            this.receiveRemoveRoutes(removeRoutes);
        } else {
            super.handleCommand(message);
        }
    }

    private void receiveAddRoutes(Messages.AddOrUpdateRoutes msg) {
        this.LOG.debug("AddOrUpdateRoutes: {}", msg.getRouteIdentifiers());
        this.updateLocalBucket(((RoutingTable)this.getLocalData()).addRpcs(msg.getRouteIdentifiers()));
    }

    private void receiveRemoveRoutes(Messages.RemoveRoutes msg) {
        this.LOG.debug("RemoveRoutes: {}", msg.getRouteIdentifiers());
        this.updateLocalBucket(((RoutingTable)this.getLocalData()).removeRpcs(msg.getRouteIdentifiers()));
    }

    @Override
    protected void onBucketRemoved(Address address, Bucket<RoutingTable> bucket) {
        this.rpcRegistrar.tell((Object)new Messages.UpdateRemoteEndpoints((Map<Address, Optional<RemoteRpcEndpoint>>)ImmutableMap.of((Object)address, Optional.empty())), ActorRef.noSender());
    }

    @Override
    protected void onBucketsUpdated(Map<Address, Bucket<RoutingTable>> buckets) {
        HashMap<Address, Optional<RemoteRpcEndpoint>> endpoints = new HashMap<Address, Optional<RemoteRpcEndpoint>>(buckets.size());
        Iterator<Map.Entry<Address, Bucket<RoutingTable>>> iterator = buckets.entrySet().iterator();
        while (iterator.hasNext()) {
            RoutingTable table;
            ImmutableSet rpcs;
            Map.Entry<Address, Bucket<RoutingTable>> e;
            endpoints.put(e.getKey(), (rpcs = (table = (e = iterator.next()).getValue().getData()).getItems()).isEmpty() ? Optional.empty() : Optional.of(new RemoteRpcEndpoint(table.getInvoker(), (Collection<DOMRpcIdentifier>)rpcs)));
        }
        if (!endpoints.isEmpty()) {
            this.rpcRegistrar.tell((Object)new Messages.UpdateRemoteEndpoints(endpoints), ActorRef.noSender());
        }
    }

    public static class Messages {

        public static final class UpdateRemoteEndpoints {
            private final Map<Address, Optional<RemoteRpcEndpoint>> rpcEndpoints;

            @VisibleForTesting
            public UpdateRemoteEndpoints(Map<Address, Optional<RemoteRpcEndpoint>> rpcEndpoints) {
                this.rpcEndpoints = ImmutableMap.copyOf(rpcEndpoints);
            }

            public Map<Address, Optional<RemoteRpcEndpoint>> getRpcEndpoints() {
                return this.rpcEndpoints;
            }
        }

        public static final class RemoveRoutes
        extends AbstractRouteMessage {
            public RemoveRoutes(Collection<DOMRpcIdentifier> rpcRouteIdentifiers) {
                super(rpcRouteIdentifiers);
            }
        }

        public static final class AddOrUpdateRoutes
        extends AbstractRouteMessage {
            public AddOrUpdateRoutes(Collection<DOMRpcIdentifier> rpcRouteIdentifiers) {
                super(rpcRouteIdentifiers);
            }
        }

        static abstract class AbstractRouteMessage {
            final List<DOMRpcIdentifier> rpcRouteIdentifiers;

            AbstractRouteMessage(Collection<DOMRpcIdentifier> rpcRouteIdentifiers) {
                Preconditions.checkArgument((rpcRouteIdentifiers != null && !rpcRouteIdentifiers.isEmpty() ? 1 : 0) != 0, (Object)"Route Identifiers must be supplied");
                this.rpcRouteIdentifiers = ImmutableList.copyOf(rpcRouteIdentifiers);
            }

            List<DOMRpcIdentifier> getRouteIdentifiers() {
                return this.rpcRouteIdentifiers;
            }

            public String toString() {
                return "ContainsRoute{routeIdentifiers=" + this.rpcRouteIdentifiers + "}";
            }
        }
    }

    public static final class RemoteRpcEndpoint {
        private final Set<DOMRpcIdentifier> rpcs;
        private final ActorRef router;

        @VisibleForTesting
        public RemoteRpcEndpoint(ActorRef router, Collection<DOMRpcIdentifier> rpcs) {
            this.router = Objects.requireNonNull(router);
            this.rpcs = ImmutableSet.copyOf(rpcs);
        }

        public ActorRef getRouter() {
            return this.router;
        }

        public Set<DOMRpcIdentifier> getRpcs() {
            return this.rpcs;
        }
    }
}

