/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Verify;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MandatoryDescendant
implements Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(MandatoryDescendant.class);
    private final @NonNull YangInstanceIdentifier path;
    private final @Nullable YangInstanceIdentifier legacyPath;

    private MandatoryDescendant(YangInstanceIdentifier path, YangInstanceIdentifier legacyPath) {
        this.path = Objects.requireNonNull(path);
        this.legacyPath = legacyPath;
    }

    static @NonNull MandatoryDescendant create(YangInstanceIdentifier parentId, DataNodeContainer parentSchema, DataSchemaNode childSchema, boolean inAugmentedSubtree) {
        YangInstanceIdentifier.NodeIdentifier childId = YangInstanceIdentifier.NodeIdentifier.create((QName)childSchema.getQName());
        if (childSchema.isAugmenting()) {
            if (!inAugmentedSubtree) {
                AugmentationSchemaNode aug = MandatoryDescendant.getAugIdentifierOfChild(parentSchema, childSchema);
                return new MandatoryDescendant(parentId.node((YangInstanceIdentifier.PathArgument)DataSchemaContextNode.augmentationIdentifierFrom((AugmentationSchemaNode)aug)).node((YangInstanceIdentifier.PathArgument)childId).toOptimized(), parentId.node((YangInstanceIdentifier.PathArgument)childId).toOptimized());
            }
            List augSubtreePath = parentId.getPathArguments();
            YangInstanceIdentifier legacyPath = !augSubtreePath.isEmpty() ? YangInstanceIdentifier.create(augSubtreePath.subList(1, augSubtreePath.size())) : null;
            return new MandatoryDescendant(parentId.node((YangInstanceIdentifier.PathArgument)childId).toOptimized(), legacyPath);
        }
        return new MandatoryDescendant(parentId.node((YangInstanceIdentifier.PathArgument)childId).toOptimized(), null);
    }

    void enforceOnData(NormalizedNode data) {
        if (NormalizedNodes.findNode((NormalizedNode)data, (YangInstanceIdentifier)this.path).isPresent()) {
            return;
        }
        if (this.legacyPath != null && NormalizedNodes.findNode((NormalizedNode)data, (YangInstanceIdentifier)this.legacyPath).isPresent()) {
            LOG.debug("Found {} at alternate path {}", (Object)this.path, (Object)this.legacyPath);
            return;
        }
        throw new IllegalArgumentException(String.format("Node %s is missing mandatory descendant %s", data.getIdentifier(), this.path));
    }

    static AugmentationSchemaNode getAugIdentifierOfChild(DataNodeContainer parent, DataSchemaNode child) {
        Verify.verify((boolean)(parent instanceof AugmentationTarget), (String)"Unexpected augmenting child %s in non-target parent %s", (Object)child, (Object)parent);
        return ((AugmentationTarget)parent).getAvailableAugmentations().stream().filter(augment -> augment.findDataChildByName(child.getQName()).isPresent()).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Node %s is marked as augmenting but is not present in the schema of %s", child.getQName(), parent)));
    }

    public String toString() {
        return this.legacyPath == null ? this.path.toString() : "(" + this.path + " || " + this.legacyPath + ")";
    }
}

