/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.impl.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.NodeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;

final class ModifiedNode
extends NodeModification
implements StoreTreeNode<ModifiedNode> {
    static final Predicate<ModifiedNode> IS_TERMINAL_PREDICATE = input -> switch (input.getOperation()) {
        default -> throw new IncompatibleClassChangeError();
        case LogicalOperation.DELETE, LogicalOperation.MERGE, LogicalOperation.WRITE -> true;
        case LogicalOperation.NONE, LogicalOperation.TOUCH -> false;
    };
    private final Map<YangInstanceIdentifier.PathArgument, ModifiedNode> children;
    private final Optional<? extends TreeNode> original;
    private final YangInstanceIdentifier.PathArgument identifier;
    private LogicalOperation operation = LogicalOperation.NONE;
    private Optional<TreeNode> snapshotCache;
    private NormalizedNode value;
    private ModificationType modType;
    private TreeNode writtenOriginal;
    private ModificationApplyOperation validatedOp;
    private Optional<? extends TreeNode> validatedCurrent;
    private Optional<? extends TreeNode> validatedNode;

    private ModifiedNode(YangInstanceIdentifier.PathArgument identifier, Optional<? extends TreeNode> original, ChildTrackingPolicy childPolicy) {
        this.identifier = identifier;
        this.original = original;
        this.children = childPolicy.createMap();
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    @Override
    LogicalOperation getOperation() {
        return this.operation;
    }

    @Override
    Optional<? extends TreeNode> getOriginal() {
        return this.original;
    }

    @NonNull NormalizedNode getWrittenValue() {
        return (NormalizedNode)Verify.verifyNotNull((Object)this.value);
    }

    public ModifiedNode childByArg(YangInstanceIdentifier.PathArgument arg) {
        return this.children.get(arg);
    }

    private Optional<? extends TreeNode> metadataFromSnapshot(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child) {
        return this.original.isPresent() ? this.original.get().findChildByArg(child) : Optional.empty();
    }

    private Optional<? extends TreeNode> metadataFromData(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child, Version modVersion) {
        if (this.writtenOriginal == null) {
            this.writtenOriginal = TreeNode.of(this.value, modVersion);
        }
        return this.writtenOriginal.findChildByArg(child);
    }

    private Optional<? extends TreeNode> findOriginalMetadata(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child, Version modVersion) {
        return switch (this.operation) {
            default -> throw new IncompatibleClassChangeError();
            case LogicalOperation.DELETE -> Optional.empty();
            case LogicalOperation.NONE, LogicalOperation.TOUCH, LogicalOperation.MERGE -> this.metadataFromSnapshot(child);
            case LogicalOperation.WRITE -> this.metadataFromData(child, modVersion);
        };
    }

    ModifiedNode modifyChild(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child, @NonNull ModificationApplyOperation childOper, @NonNull Version modVersion) {
        NormalizedNode childData;
        ModifiedNode potential;
        this.clearSnapshot();
        if (this.operation == LogicalOperation.NONE) {
            this.updateOperationType(LogicalOperation.TOUCH);
        }
        if ((potential = this.children.get(child)) != null) {
            return potential;
        }
        Optional<? extends TreeNode> currentMetadata = this.findOriginalMetadata(child, modVersion);
        ModifiedNode newlyCreated = new ModifiedNode(child, currentMetadata, childOper.getChildPolicy());
        if (this.operation == LogicalOperation.MERGE && this.value != null && (childData = ((DistinctNodeContainer)this.value).childByArg(child)) != null) {
            childOper.mergeIntoModifiedNode(newlyCreated, childData, modVersion);
        }
        this.children.put(child, newlyCreated);
        return newlyCreated;
    }

    Collection<ModifiedNode> getChildren() {
        return this.children.values();
    }

    void delete() {
        LogicalOperation newType = switch (this.operation) {
            default -> throw new IncompatibleClassChangeError();
            case LogicalOperation.DELETE, LogicalOperation.NONE -> LogicalOperation.DELETE;
            case LogicalOperation.MERGE -> LogicalOperation.DELETE;
            case LogicalOperation.TOUCH, LogicalOperation.WRITE -> this.original.isPresent() ? LogicalOperation.DELETE : LogicalOperation.NONE;
        };
        this.clearSnapshot();
        this.children.clear();
        this.value = null;
        this.updateOperationType(newType);
    }

    void write(NormalizedNode newValue) {
        this.updateValue(LogicalOperation.WRITE, newValue);
        this.children.clear();
    }

    void seal(ModificationApplyOperation schema, Version version) {
        this.clearSnapshot();
        this.writtenOriginal = null;
        switch (this.operation) {
            case TOUCH: {
                if (!this.children.isEmpty()) break;
                this.updateOperationType(LogicalOperation.NONE);
                break;
            }
            case WRITE: {
                if (!this.children.isEmpty()) {
                    this.value = schema.apply(this, this.getOriginal(), version).map(TreeNode::getData).orElse(null);
                    this.children.clear();
                }
                if (this.value == null) {
                    this.updateOperationType(LogicalOperation.DELETE);
                    break;
                }
                schema.fullVerifyStructure(this.value);
                break;
            }
        }
    }

    private void clearSnapshot() {
        this.snapshotCache = null;
    }

    Optional<TreeNode> getSnapshot() {
        return this.snapshotCache;
    }

    Optional<TreeNode> setSnapshot(Optional<TreeNode> snapshot) {
        this.snapshotCache = Objects.requireNonNull(snapshot);
        return snapshot;
    }

    void updateOperationType(LogicalOperation type) {
        this.operation = type;
        this.modType = null;
        this.writtenOriginal = null;
        this.clearSnapshot();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).omitNullValues().add("identifier", (Object)this.identifier).add("operation", (Object)this.operation).add("modificationType", (Object)this.modType);
        if (!this.children.isEmpty()) {
            helper.add("childModification", this.children);
        }
        return helper.toString();
    }

    void resolveModificationType(@NonNull ModificationType type) {
        this.modType = type;
    }

    void updateValue(LogicalOperation type, NormalizedNode newValue) {
        this.value = Objects.requireNonNull(newValue);
        this.updateOperationType(type);
    }

    ModificationType getModificationType() {
        return this.modType;
    }

    public static ModifiedNode createUnmodified(TreeNode metadataTree, ChildTrackingPolicy childPolicy) {
        return new ModifiedNode(metadataTree.getIdentifier(), Optional.of(metadataTree), childPolicy);
    }

    void setValidatedNode(ModificationApplyOperation op, Optional<? extends TreeNode> current, Optional<? extends TreeNode> node) {
        this.validatedOp = Objects.requireNonNull(op);
        this.validatedCurrent = Objects.requireNonNull(current);
        this.validatedNode = Objects.requireNonNull(node);
    }

    @SuppressFBWarnings(value={"NP_OPTIONAL_RETURN_NULL"}, justification="The contract is package-internal and well documented, we do not need a separate wrapper")
    @Nullable Optional<? extends TreeNode> getValidatedNode(ModificationApplyOperation op, Optional<? extends TreeNode> current) {
        return op.equals(this.validatedOp) && current.equals(this.validatedCurrent) ? this.validatedNode : null;
    }
}

