/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.TransactionReadyReplyMapper;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransaction;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;

class LocalThreePhaseCommitCohort
implements DOMStoreThreePhaseCommitCohort {
    private static final Logger LOG = LoggerFactory.getLogger(LocalThreePhaseCommitCohort.class);
    private final SnapshotBackedWriteTransaction<TransactionIdentifier> transaction;
    private final DataTreeModification modification;
    private final ActorUtils actorUtils;
    private final ActorSelection leader;
    private final Exception operationError;

    protected LocalThreePhaseCommitCohort(ActorUtils actorUtils, ActorSelection leader, SnapshotBackedWriteTransaction<TransactionIdentifier> transaction, DataTreeModification modification, Exception operationError) {
        this.actorUtils = Objects.requireNonNull(actorUtils);
        this.leader = Objects.requireNonNull(leader);
        this.transaction = Objects.requireNonNull(transaction);
        this.modification = Objects.requireNonNull(modification);
        this.operationError = operationError;
    }

    protected LocalThreePhaseCommitCohort(ActorUtils actorUtils, ActorSelection leader, SnapshotBackedWriteTransaction<TransactionIdentifier> transaction, Exception operationError) {
        this.actorUtils = Objects.requireNonNull(actorUtils);
        this.leader = Objects.requireNonNull(leader);
        this.transaction = Objects.requireNonNull(transaction);
        this.operationError = Objects.requireNonNull(operationError);
        this.modification = null;
    }

    private Future<Object> initiateCommit(boolean immediate, Optional<SortedSet<String>> participatingShardNames) {
        if (this.operationError != null) {
            return Futures.failed((Throwable)this.operationError);
        }
        ReadyLocalTransaction message = new ReadyLocalTransaction((TransactionIdentifier)this.transaction.getIdentifier(), this.modification, immediate, participatingShardNames);
        return this.actorUtils.executeOperationAsync(this.leader, (Object)message, this.actorUtils.getTransactionCommitOperationTimeout());
    }

    Future<ActorSelection> initiateCoordinatedCommit(Optional<SortedSet<String>> participatingShardNames) {
        Future<Object> messageFuture = this.initiateCommit(false, participatingShardNames);
        Future<ActorSelection> ret = TransactionReadyReplyMapper.transform(messageFuture, this.actorUtils, (TransactionIdentifier)this.transaction.getIdentifier());
        ret.onComplete((Function1)new OnComplete<ActorSelection>(){

            public void onComplete(Throwable failure, ActorSelection success) {
                if (failure != null) {
                    LOG.warn("Failed to prepare transaction {} on backend", LocalThreePhaseCommitCohort.this.transaction.getIdentifier(), (Object)failure);
                    LocalThreePhaseCommitCohort.this.transactionAborted(LocalThreePhaseCommitCohort.this.transaction);
                    return;
                }
                LOG.debug("Transaction {} resolved to actor {}", LocalThreePhaseCommitCohort.this.transaction.getIdentifier(), (Object)success);
            }
        }, this.actorUtils.getClientDispatcher());
        return ret;
    }

    Future<Object> initiateDirectCommit() {
        Future<Object> messageFuture = this.initiateCommit(true, Optional.empty());
        messageFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object message) {
                if (failure != null) {
                    LOG.warn("Failed to prepare transaction {} on backend", LocalThreePhaseCommitCohort.this.transaction.getIdentifier(), (Object)failure);
                    LocalThreePhaseCommitCohort.this.transactionAborted(LocalThreePhaseCommitCohort.this.transaction);
                } else if (CommitTransactionReply.isSerializedType(message)) {
                    LOG.debug("Transaction {} committed successfully", LocalThreePhaseCommitCohort.this.transaction.getIdentifier());
                    LocalThreePhaseCommitCohort.this.transactionCommitted(LocalThreePhaseCommitCohort.this.transaction);
                } else {
                    LOG.error("Transaction {} resulted in unhandled message type {}, aborting", LocalThreePhaseCommitCohort.this.transaction.getIdentifier(), message.getClass());
                    LocalThreePhaseCommitCohort.this.transactionAborted(LocalThreePhaseCommitCohort.this.transaction);
                }
            }
        }, this.actorUtils.getClientDispatcher());
        return messageFuture;
    }

    public final ListenableFuture<Boolean> canCommit() {
        throw new UnsupportedOperationException();
    }

    public final ListenableFuture<Empty> preCommit() {
        throw new UnsupportedOperationException();
    }

    public final ListenableFuture<Empty> abort() {
        throw new UnsupportedOperationException();
    }

    public final ListenableFuture<CommitInfo> commit() {
        throw new UnsupportedOperationException();
    }

    protected void transactionAborted(SnapshotBackedWriteTransaction<TransactionIdentifier> aborted) {
    }

    protected void transactionCommitted(SnapshotBackedWriteTransaction<TransactionIdentifier> comitted) {
    }
}

