/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(OperationLimiter.class);
    private final TransactionIdentifier identifier;
    private final long acquireTimeout;
    private final Semaphore semaphore;
    private final int maxPermits;

    OperationLimiter(TransactionIdentifier identifier, int maxPermits, long acquireTimeoutSeconds) {
        this.identifier = Objects.requireNonNull(identifier);
        Preconditions.checkArgument((acquireTimeoutSeconds >= 0L ? 1 : 0) != 0);
        this.acquireTimeout = TimeUnit.SECONDS.toNanos(acquireTimeoutSeconds);
        Preconditions.checkArgument((maxPermits >= 0 ? 1 : 0) != 0);
        this.maxPermits = maxPermits;
        this.semaphore = new Semaphore(maxPermits);
    }

    boolean acquire() {
        return this.acquire(1);
    }

    boolean acquire(int acquirePermits) {
        try {
            if (this.semaphore.tryAcquire(acquirePermits, this.acquireTimeout, TimeUnit.NANOSECONDS)) {
                return true;
            }
        }
        catch (InterruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Interrupted when trying to acquire operation permit for transaction {}", (Object)this.identifier, (Object)e);
            }
            LOG.warn("Interrupted when trying to acquire operation permit for transaction {}", (Object)this.identifier);
        }
        return false;
    }

    void release() {
        this.release(1);
    }

    void release(int permits) {
        this.semaphore.release(permits);
    }

    @VisibleForTesting
    TransactionIdentifier getIdentifier() {
        return this.identifier;
    }

    @VisibleForTesting
    int availablePermits() {
        return this.semaphore.availablePermits();
    }

    public void releaseAll() {
        this.semaphore.release(this.maxPermits - this.availablePermits());
    }
}

