/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshotMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MS
implements Externalizable {
    private static final Logger LOG = LoggerFactory.getLogger(MS.class);
    private static final long serialVersionUID = 1L;
    private Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>> metadata;
    private NormalizedNodeStreamVersion version;
    private NormalizedNode rootNode;

    public MS() {
    }

    MS(MetadataShardDataTreeSnapshot snapshot) {
        this.rootNode = snapshot.getRootNode().orElseThrow();
        this.metadata = snapshot.getMetadata();
        this.version = snapshot.version().getStreamVersion();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.metadata.size());
        for (ShardDataTreeSnapshotMetadata<?> m : this.metadata.values()) {
            out.writeObject(m);
        }
        try (NormalizedNodeDataOutput stream = this.version.newDataOutput((DataOutput)out);){
            stream.writeNormalizedNode(this.rootNode);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int metaSize = in.readInt();
        Preconditions.checkArgument((metaSize >= 0 ? 1 : 0) != 0, (String)"Invalid negative metadata map length %s", (int)metaSize);
        ImmutableMap.Builder metaBuilder = ImmutableMap.builder();
        for (int i = 0; i < metaSize; ++i) {
            ShardDataTreeSnapshotMetadata m = (ShardDataTreeSnapshotMetadata)in.readObject();
            if (m != null) {
                metaBuilder.put(m.getType(), (Object)m);
                continue;
            }
            LOG.warn("Skipping null metadata");
        }
        this.metadata = metaBuilder.build();
        NormalizedNodeDataInput stream = NormalizedNodeDataInput.newDataInput((DataInput)in);
        this.version = stream.getVersion();
        this.rootNode = stream.readNormalizedNode();
    }

    private Object readResolve() {
        return new MetadataShardDataTreeSnapshot(this.rootNode, this.metadata);
    }
}

