/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.opendaylight.controller.cluster.datastore.persisted.PurgeTransactionPayload;

final class PT
implements AbstractIdentifiablePayload.SerialForm {
    private static final long serialVersionUID = 1L;
    private TransactionIdentifier identifier;
    private byte[] bytes;

    public PT() {
    }

    PT(byte[] bytes) {
        this.bytes = Objects.requireNonNull(bytes);
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public void readExternal(byte[] newBytes) throws IOException {
        this.bytes = Objects.requireNonNull(newBytes);
        this.identifier = (TransactionIdentifier)Verify.verifyNotNull((Object)TransactionIdentifier.readFrom((DataInput)ByteStreams.newDataInput((byte[])newBytes)));
    }

    @Override
    public Object readResolve() {
        return new PurgeTransactionPayload(this.identifier, this.bytes);
    }
}

