/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.persisted.FutureVersionException;
import org.opendaylight.controller.cluster.datastore.persisted.PastVersionException;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Beta
public enum PayloadVersion implements WritableObject
{
    TEST_PAST_VERSION(0){

        @Override
        public NormalizedNodeStreamVersion getStreamVersion() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    SODIUM_SR1(7){

        @Override
        public NormalizedNodeStreamVersion getStreamVersion() {
            return NormalizedNodeStreamVersion.SODIUM_SR1;
        }
    }
    ,
    MAGNESIUM(8){

        @Override
        public NormalizedNodeStreamVersion getStreamVersion() {
            return NormalizedNodeStreamVersion.MAGNESIUM;
        }
    }
    ,
    CHLORINE_SR2(9){

        @Override
        public NormalizedNodeStreamVersion getStreamVersion() {
            return NormalizedNodeStreamVersion.MAGNESIUM;
        }
    }
    ,
    TEST_FUTURE_VERSION(65535){

        @Override
        public NormalizedNodeStreamVersion getStreamVersion() {
            throw new UnsupportedOperationException();
        }
    };

    private final short value;

    private PayloadVersion(int intVersion) {
        Preconditions.checkArgument((intVersion >= 0 && intVersion <= 65535 ? 1 : 0) != 0);
        this.value = (short)intVersion;
    }

    public short shortValue() {
        return this.value;
    }

    public abstract @NonNull NormalizedNodeStreamVersion getStreamVersion();

    public static @NonNull PayloadVersion current() {
        return CHLORINE_SR2;
    }

    public static @NonNull PayloadVersion valueOf(short version) throws FutureVersionException, PastVersionException {
        return switch (Short.toUnsignedInt(version)) {
            case 0, 1, 2, 3, 4, 5, 6 -> throw new PastVersionException(version, SODIUM_SR1);
            case 7 -> SODIUM_SR1;
            case 8 -> MAGNESIUM;
            case 9 -> CHLORINE_SR2;
            default -> throw new FutureVersionException(version, CHLORINE_SR2);
        };
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeShort(this.value);
    }

    public static @NonNull PayloadVersion readFrom(@NonNull DataInput in) throws IOException {
        short s = in.readShort();
        try {
            return PayloadVersion.valueOf(s);
        }
        catch (FutureVersionException | PastVersionException e) {
            throw new IOException(e);
        }
    }
}

