/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.Props;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManager;
import org.opendaylight.controller.cluster.datastore.utils.PrimaryShardInfoFutureCache;
import org.opendaylight.yangtools.yang.common.Empty;

public abstract class AbstractShardManagerCreator<T extends AbstractShardManagerCreator<T>> {
    private SettableFuture<Empty> readinessFuture;
    private ClusterWrapper cluster;
    private Configuration configuration;
    private DatastoreContextFactory datastoreContextFactory;
    private AbstractDataStore distributedDataStore;
    private PrimaryShardInfoFutureCache primaryShardInfoCache;
    private DatastoreSnapshot restoreFromSnapshot;
    private volatile boolean sealed;

    AbstractShardManagerCreator() {
    }

    private T self() {
        return (T)this;
    }

    protected final void checkSealed() {
        Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (Object)"Builder is already sealed - further modifications are not allowed");
    }

    ClusterWrapper getCluster() {
        return this.cluster;
    }

    public T cluster(ClusterWrapper newCluster) {
        this.checkSealed();
        this.cluster = newCluster;
        return this.self();
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public T configuration(Configuration newConfiguration) {
        this.checkSealed();
        this.configuration = newConfiguration;
        return this.self();
    }

    DatastoreContextFactory getDatastoreContextFactory() {
        return this.datastoreContextFactory;
    }

    public T datastoreContextFactory(DatastoreContextFactory newDatastoreContextFactory) {
        this.checkSealed();
        this.datastoreContextFactory = Objects.requireNonNull(newDatastoreContextFactory);
        return this.self();
    }

    AbstractDataStore getDistributedDataStore() {
        return this.distributedDataStore;
    }

    public T distributedDataStore(AbstractDataStore newDistributedDataStore) {
        this.checkSealed();
        this.distributedDataStore = newDistributedDataStore;
        return this.self();
    }

    SettableFuture<Empty> getReadinessFuture() {
        return this.readinessFuture;
    }

    public T readinessFuture(SettableFuture<Empty> newReadinessFuture) {
        this.checkSealed();
        this.readinessFuture = newReadinessFuture;
        return this.self();
    }

    PrimaryShardInfoFutureCache getPrimaryShardInfoCache() {
        return this.primaryShardInfoCache;
    }

    public T primaryShardInfoCache(PrimaryShardInfoFutureCache newPrimaryShardInfoCache) {
        this.checkSealed();
        this.primaryShardInfoCache = newPrimaryShardInfoCache;
        return this.self();
    }

    DatastoreSnapshot getRestoreFromSnapshot() {
        return this.restoreFromSnapshot;
    }

    public T restoreFromSnapshot(DatastoreSnapshot newRestoreFromSnapshot) {
        this.checkSealed();
        this.restoreFromSnapshot = newRestoreFromSnapshot;
        return this.self();
    }

    protected void verify() {
        this.sealed = true;
        Objects.requireNonNull(this.cluster, "cluster should not be null");
        Objects.requireNonNull(this.configuration, "configuration should not be null");
        Objects.requireNonNull(this.datastoreContextFactory, "datastoreContextFactory should not be null");
        Objects.requireNonNull(this.distributedDataStore, "distributedDataStore should not be null");
        Objects.requireNonNull(this.readinessFuture, "readinessFuture should not be null");
        Objects.requireNonNull(this.primaryShardInfoCache, "primaryShardInfoCache should not be null");
    }

    public Props props() {
        this.verify();
        return Props.create(ShardManager.class, (Object[])new Object[]{this});
    }
}

