/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class AnydataStatementSupport
extends AbstractSchemaTreeStatementSupport<AnydataStatement, AnydataEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ANYDATA).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();

    public AnydataStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.ANYDATA, AnydataStatementSupport.instantiatedPolicy(), config, SUBSTATEMENT_VALIDATOR);
    }

    protected AnydataStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createAnydata((QName)((QName)ctx.getArgument()), substatements);
    }

    protected AnydataStatement attachDeclarationReference(AnydataStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateAnydata((AnydataStatement)stmt, (DeclarationReference)reference);
    }

    protected AnydataEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, AnydataStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createAnydata((AnydataStatement)((AnydataStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)AnydataStatementSupport.createFlags(stmt, substatements), substatements);
    }

    public AnydataEffectiveStatement copyEffective(EffectiveStmtCtx.Current<QName, AnydataStatement> stmt, AnydataEffectiveStatement original) {
        return EffectiveStatements.copyAnydata((AnydataEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)AnydataStatementSupport.createFlags(stmt, original.effectiveSubstatements()));
    }

    public EffectiveStatementState extractEffectiveState(AnydataEffectiveStatement stmt) {
        Verify.verify((boolean)(stmt instanceof AnydataSchemaNode), (String)"Unexpected statement %s", (Object)stmt);
        AnydataSchemaNode schema = (AnydataSchemaNode)stmt;
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)schema).setStatus(schema.getStatus()).setConfiguration((Boolean)schema.effectiveConfig().orElse(null)).setMandatory(schema.isMandatory()).toFlags());
    }

    private static int createFlags(EffectiveStmtCtx.Current<?, ?> stmt, Collection<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)stmt.history()).setStatus((Status)AnydataStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).setConfiguration(stmt.effectiveConfig().asNullable()).setMandatory(((Boolean)AnydataStatementSupport.findFirstArgument(substatements, MandatoryEffectiveStatement.class, (Object)Boolean.FALSE)).booleanValue()).toFlags();
    }
}

