/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.IncludeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IncludeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractUnqualifiedStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.YangVersionLinkageException;

@Beta
public final class IncludeStatementSupport
extends AbstractUnqualifiedStatementSupport<IncludeStatement, IncludeEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.INCLUDE).addOptional((StatementDefinition)YangStmtMapping.REVISION_DATE).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.INCLUDE).addOptional((StatementDefinition)YangStmtMapping.REVISION_DATE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();

    IncludeStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.INCLUDE, StatementSupport.StatementPolicy.reject(), config, validator);
    }

    public static @NonNull IncludeStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new IncludeStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull IncludeStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new IncludeStatementSupport(config, RFC7950_VALIDATOR);
    }

    public void onPreLinkageDeclared(StmtContext.Mutable<UnresolvedQName.Unqualified, IncludeStatement, IncludeEffectiveStatement> stmt) {
        StmtContext revision = StmtContextUtils.findFirstDeclaredSubstatement(stmt, RevisionDateStatement.class);
        stmt.addRequiredSource(new SourceIdentifier((UnresolvedQName.Unqualified)stmt.getArgument(), revision != null ? (Revision)revision.getArgument() : null));
    }

    public void onLinkageDeclared(final StmtContext.Mutable<UnresolvedQName.Unqualified, IncludeStatement, IncludeEffectiveStatement> stmt) {
        final UnresolvedQName.Unqualified submoduleName = (UnresolvedQName.Unqualified)stmt.getArgument();
        final StmtContext revision = StmtContextUtils.findFirstDeclaredSubstatement(stmt, RevisionDateStatement.class);
        ModelActionBuilder includeAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
        final ModelActionBuilder.Prerequisite requiresCtxPrerequisite = revision == null ? includeAction.requiresCtx(stmt, ParserNamespaces.SUBMODULE, NamespaceKeyCriterion.latestRevisionModule((UnresolvedQName.Unqualified)submoduleName), ModelProcessingPhase.SOURCE_LINKAGE) : includeAction.requiresCtx(stmt, ParserNamespaces.SUBMODULE, (Object)new SourceIdentifier(submoduleName, (Revision)revision.argument()), ModelProcessingPhase.SOURCE_LINKAGE);
        includeAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext includedSubModuleContext = (StmtContext)requiresCtxPrerequisite.resolve(ctx);
                YangVersion modVersion = stmt.getRoot().yangVersion();
                YangVersion subVersion = includedSubModuleContext.yangVersion();
                if (subVersion != modVersion) {
                    throw new YangVersionLinkageException((CommonStmtCtx)stmt, "Cannot include a version %s submodule in a version %s module", new Object[]{subVersion, modVersion});
                }
                stmt.addToNs(ParserNamespaces.INCLUDED_MODULE, (Object)new SourceIdentifier(submoduleName, revision != null ? (Revision)revision.getArgument() : null), (Object)includedSubModuleContext);
                stmt.addToNs(ParserNamespaces.INCLUDED_SUBMODULE_NAME_TO_MODULECTX, (Object)((UnresolvedQName.Unqualified)stmt.argument()), (Object)includedSubModuleContext);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(requiresCtxPrerequisite), (CommonStmtCtx)stmt, (String)"Included submodule '%s' was not found: ", (Object[])new Object[]{stmt.argument()});
            }
        });
    }

    protected IncludeStatement createDeclared(BoundStmtCtx<UnresolvedQName.Unqualified> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createInclude((UnresolvedQName.Unqualified)((UnresolvedQName.Unqualified)ctx.getArgument()), substatements);
    }

    protected IncludeStatement attachDeclarationReference(IncludeStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateInclude((IncludeStatement)stmt, (DeclarationReference)reference);
    }

    protected IncludeEffectiveStatement createEffective(EffectiveStmtCtx.Current<UnresolvedQName.Unqualified, IncludeStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createInclude((IncludeStatement)((IncludeStatement)stmt.declared()), substatements);
    }
}

