/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnresolvedNumber;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueRange;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class LengthStatementSupport
extends AbstractStatementSupport<List<ValueRange>, LengthStatement, LengthEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.LENGTH).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.ERROR_APP_TAG).addOptional((StatementDefinition)YangStmtMapping.ERROR_MESSAGE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();

    public LengthStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.LENGTH, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public ImmutableList<ValueRange> parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        ArrayList<ValueRange> ranges = new ArrayList<ValueRange>();
        for (String singleRange : ArgumentUtils.PIPE_SPLITTER.split((CharSequence)value)) {
            Number max;
            Iterator boundaries = ArgumentUtils.TWO_DOTS_SPLITTER.split((CharSequence)singleRange).iterator();
            Number min = LengthStatementSupport.parseIntegerConstraintValue(ctx, (String)boundaries.next());
            if (boundaries.hasNext()) {
                max = LengthStatementSupport.parseIntegerConstraintValue(ctx, (String)boundaries.next());
                SourceException.throwIf((ArgumentUtils.compareNumbers(min, max) == 1 ? 1 : 0) != 0, ctx, (String)"Length constraint %s has descending order of boundaries; should be ascending.", (Object[])new Object[]{singleRange});
                SourceException.throwIf((boolean)boundaries.hasNext(), ctx, (String)"Wrong number of boundaries in length constraint %s.", (Object[])new Object[]{singleRange});
            } else {
                max = min;
            }
            InferenceException.throwIf((ranges.size() > 1 && ArgumentUtils.compareNumbers(min, ((ValueRange)Iterables.getLast(ranges)).upperBound()) != 1 ? 1 : 0) != 0, ctx, (String)"Some of the length ranges in %s are not disjoint", (Object[])new Object[]{value});
            ranges.add(ValueRange.of((Number)min, (Number)max));
        }
        return ImmutableList.copyOf(ranges);
    }

    protected LengthStatement createDeclared(BoundStmtCtx<List<ValueRange>> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createLength((String)ctx.getRawArgument(), (List)((List)ctx.getArgument()), substatements);
    }

    protected LengthStatement attachDeclarationReference(LengthStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateLength((LengthStatement)stmt, (DeclarationReference)reference);
    }

    protected LengthEffectiveStatement createEffective(EffectiveStmtCtx.Current<List<ValueRange>, LengthStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createLength((LengthStatement)((LengthStatement)stmt.declared()), substatements);
    }

    private static @NonNull Number parseIntegerConstraintValue(StmtContext<?, ?, ?> ctx, String value) {
        if ("max".equals(value)) {
            return UnresolvedNumber.max();
        }
        if ("min".equals(value)) {
            return UnresolvedNumber.min();
        }
        try {
            return Uint64.valueOf((String)value).intern();
        }
        catch (NumberFormatException e) {
            throw new SourceException(ctx, (Throwable)e, "Value %s is not a valid unsigned integer", new Object[]{value});
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx, (Throwable)e, "Value %s exceeds maximum supported value %s", new Object[]{value, Uint64.MAX_VALUE});
        }
    }
}

