/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import java.time.format.DateTimeParseException;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class RevisionStatementSupport
extends AbstractStatementSupport<Revision, RevisionStatement, RevisionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.REVISION).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();

    public RevisionStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.REVISION, StatementSupport.StatementPolicy.reject(), config, SUBSTATEMENT_VALIDATOR);
    }

    public Revision parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Revision.of((String)value);
        }
        catch (DateTimeParseException e) {
            throw new SourceException(ctx, (Throwable)e, "Revision value %s is not in required format yyyy-MM-dd", new Object[]{value});
        }
    }

    protected RevisionStatement createDeclared(BoundStmtCtx<Revision> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createRevision((Revision)((Revision)ctx.getArgument()), substatements);
    }

    protected RevisionStatement attachDeclarationReference(RevisionStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateRevision((RevisionStatement)stmt, (DeclarationReference)reference);
    }

    protected RevisionEffectiveStatement createEffective(EffectiveStmtCtx.Current<Revision, RevisionStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createRevision((RevisionStatement)((RevisionStatement)stmt.declared()), substatements);
    }
}

