/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractBindingNormalizedNodeCache;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectNormalizedNodeCache;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.TypeObjectNormalizedNodeCache;
import org.opendaylight.yangtools.yang.binding.BindingObject;

abstract class AbstractBindingNormalizedNodeCacheHolder {
    private final LoadingCache<NodeCodecContext, AbstractBindingNormalizedNodeCache> caches = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<NodeCodecContext, AbstractBindingNormalizedNodeCache>(){

        public AbstractBindingNormalizedNodeCache load(NodeCodecContext key) {
            if (key instanceof DataContainerCodecContext) {
                return new DataObjectNormalizedNodeCache(AbstractBindingNormalizedNodeCacheHolder.this, (DataContainerCodecContext)key);
            }
            if (key instanceof LeafNodeCodecContext.OfTypeObject) {
                return new TypeObjectNormalizedNodeCache<LeafNodeCodecContext.OfTypeObject>((LeafNodeCodecContext.OfTypeObject)key);
            }
            throw new IllegalStateException("Unhandled context " + key);
        }
    });
    private final ImmutableSet<Class<? extends BindingObject>> cacheSpec;

    AbstractBindingNormalizedNodeCacheHolder(ImmutableSet<Class<? extends BindingObject>> cacheSpec) {
        this.cacheSpec = Objects.requireNonNull(cacheSpec);
    }

    <T extends BindingObject, C extends NodeCodecContext> AbstractBindingNormalizedNodeCache<T, C> getCachingSerializer(C childCtx) {
        return this.isCached(((BindingObjectCodecTreeNode)childCtx).getBindingClass()) ? (AbstractBindingNormalizedNodeCache)((Object)this.caches.getUnchecked(childCtx)) : null;
    }

    final boolean isCached(Class<? extends BindingObject> type) {
        return this.cacheSpec.contains(type);
    }
}

