/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.GenericFilter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiInitializedFilter;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.ScopedFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

public class PaxWebFilterDef
extends FilterDef {
    private final FilterModel filterModel;
    private final boolean initialFilter;
    private ServiceReference<Filter> filterReference;
    private OsgiScopedServletContext servletContext = null;
    private boolean whiteboardTCCL;

    public PaxWebFilterDef(FilterModel filterModel, boolean initialFilter, OsgiServletContext osgiContext) {
        this.filterModel = filterModel;
        this.initialFilter = initialFilter;
        this.setFilterName(filterModel.getName());
        Filter instance = null;
        if (filterModel.getFilterClass() != null) {
            try {
                instance = (Filter)filterModel.getFilterClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Can't instantiate filter of class " + filterModel.getFilterClass());
            }
        } else if (filterModel.getFilter() != null) {
            instance = filterModel.getFilter();
        } else if (filterModel.getElementSupplier() != null) {
            instance = (Filter)filterModel.getElementSupplier().get();
        } else {
            this.filterReference = filterModel.getElementReference();
        }
        filterModel.getInitParams().forEach((arg_0, arg_1) -> ((PaxWebFilterDef)this).addInitParameter(arg_0, arg_1));
        this.setAsyncSupported(filterModel.getAsyncSupported() != null && filterModel.getAsyncSupported() != false ? "true" : "false");
        if (osgiContext != null) {
            this.servletContext = new OsgiScopedServletContext(osgiContext, filterModel.getRegisteringBundle());
        }
        if (this.isInitial()) {
            this.setFilter(instance);
        } else {
            this.setFilter(instance == null || this.servletContext == null ? null : instance);
        }
    }

    public void setFilter(Filter filter) {
        if (this.isInitial()) {
            super.setFilter(filter);
        } else {
            LifecycleFilter delegate = filter == null ? new LifecycleFilter() : new ScopedFilter((Filter)new OsgiInitializedFilter(filter, this.filterModel, (ServletContext)this.servletContext, this.whiteboardTCCL), this.filterModel);
            super.setFilter((Filter)delegate);
        }
    }

    public boolean matches(OsgiContextModel targetContext) {
        return this.initialFilter || this.filterModel.getContextModels().contains(targetContext);
    }

    public boolean isInitial() {
        return this.initialFilter;
    }

    public FilterModel getFilterModel() {
        return this.filterModel;
    }

    public void setWhiteboardTCCL(boolean whiteboardTCCL) {
        this.whiteboardTCCL = whiteboardTCCL;
    }

    private class LifecycleFilter
    implements Filter {
        private Filter filter;
        private ServiceObjects<Filter> serviceObjects;

        LifecycleFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
            if (PaxWebFilterDef.this.filterReference != null) {
                Filter instance = null;
                BundleContext context = PaxWebFilterDef.this.filterModel.getRegisteringBundle().getBundleContext();
                if (context != null) {
                    if (!PaxWebFilterDef.this.filterModel.isPrototype()) {
                        instance = (Filter)context.getService(PaxWebFilterDef.this.filterReference);
                    } else {
                        this.serviceObjects = context.getServiceObjects(PaxWebFilterDef.this.filterReference);
                        instance = (Filter)this.serviceObjects.getService();
                    }
                }
                if (instance == null) {
                    PaxWebFilterDef.this.filterModel.setDtoFailureCode(5);
                }
                this.filter = new ScopedFilter((Filter)new OsgiInitializedFilter(instance, PaxWebFilterDef.this.filterModel, (ServletContext)PaxWebFilterDef.this.servletContext, PaxWebFilterDef.this.whiteboardTCCL), PaxWebFilterDef.this.filterModel);
            } else {
                this.filter = new GenericFilter(){

                    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
                        chain.doFilter(request, response);
                    }
                };
            }
            this.filter.init(filterConfig);
        }

        public void destroy() {
            this.filter.destroy();
            if (PaxWebFilterDef.this.filterReference != null) {
                if (!PaxWebFilterDef.this.filterModel.isPrototype()) {
                    BundleContext context = PaxWebFilterDef.this.filterModel.getRegisteringBundle().getBundleContext();
                    if (context != null) {
                        context.ungetService(PaxWebFilterDef.this.filterReference);
                    }
                } else {
                    Filter realFilter = this.filter;
                    if (realFilter instanceof ScopedFilter) {
                        realFilter = ((ScopedFilter)realFilter).getDelegate();
                    }
                    if (realFilter instanceof OsgiInitializedFilter) {
                        realFilter = ((OsgiInitializedFilter)realFilter).getDelegate();
                    }
                    this.serviceObjects.ungetService((Object)realFilter);
                }
            }
            if (PaxWebFilterDef.this.servletContext != null && PaxWebFilterDef.this.filterModel.getRegisteringBundle() != null) {
                PaxWebFilterDef.this.servletContext.releaseWebContainerContext(PaxWebFilterDef.this.filterModel.getRegisteringBundle());
            }
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.filter.doFilter(request, response, chain);
        }
    }
}

