/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.valves.ValveBase;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiInitializedServlet;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebScopedStandardContext;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardContext;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardWrapperValve;
import org.ops4j.pax.web.service.tomcat.internal.web.TomcatResourceServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

public class PaxWebStandardWrapper
extends StandardWrapper {
    private final ServletModel servletModel;
    private final OsgiContextModel osgiContextModel;
    private final PaxWebStandardContext realContext;
    private Class<? extends Servlet> servletClass;
    private ServiceReference<Servlet> serviceReference;
    private final OsgiServletContext osgiServletContext;
    private final OsgiScopedServletContext servletContext;
    private ServiceObjects<Servlet> serviceObjects;
    private final WebContainerContext webContainerContext;
    private boolean is404 = false;
    private Container originalParent;
    private boolean whiteboardTCCL;

    PaxWebStandardWrapper(String name, PaxWebStandardContext container, Servlet servlet, boolean is404) {
        this.servletModel = null;
        this.osgiContextModel = null;
        this.osgiServletContext = null;
        this.realContext = container;
        this.servletContext = null;
        this.webContainerContext = null;
        this.is404 = is404;
        this.setName(name);
        this.setServlet(servlet);
        this.setParent(container);
        this.getPipeline().addValve(new PaxWebStandardWrapperValve((ValveBase)this.getPipeline().getBasic(), this));
    }

    public PaxWebStandardWrapper(ServletModel servletModel, OsgiContextModel osgiContextModel, OsgiServletContext osgiServletContext, PaxWebStandardContext realContext) {
        this.servletModel = servletModel;
        this.osgiContextModel = osgiContextModel;
        this.osgiServletContext = osgiServletContext;
        this.realContext = realContext;
        this.setName(servletModel.getName());
        if (servletModel.getServletClass() != null) {
            this.servletClass = servletModel.getServletClass();
        } else if (servletModel.getServlet() != null) {
            this.setServlet(servletModel.getServlet());
        } else {
            this.serviceReference = servletModel.getElementReference();
        }
        this.parameters.clear();
        this.parameters.putAll(servletModel.getInitParams());
        this.setAsyncSupported(servletModel.getAsyncSupported() != null && servletModel.getAsyncSupported() != false);
        if (servletModel.getLoadOnStartup() != null) {
            this.setLoadOnStartup(servletModel.getLoadOnStartup());
        }
        this.setMultipartConfigElement(servletModel.getMultipartConfigElement());
        this.servletContext = new OsgiScopedServletContext(this.osgiServletContext, servletModel.getRegisteringBundle());
        this.webContainerContext = this.servletContext.getResolvedWebContainerContext();
        this.setOverridable(servletModel.isOverridable());
        this.getPipeline().addValve(new PaxWebStandardWrapperValve((ValveBase)this.getPipeline().getBasic(), this));
    }

    public ServletModel getServletModel() {
        return this.servletModel;
    }

    public Bundle getRegisteringBundle() {
        return this.servletModel.getRegisteringBundle();
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        this.originalParent = this.getParent();
        this.setParent(new PaxWebScopedStandardContext(this, this.realContext));
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setParent(this.originalParent);
        super.stopInternal();
    }

    public OsgiContextModel getOsgiContextModel() {
        return this.osgiContextModel;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public OsgiServletContext getOsgiServletContext() {
        return this.osgiServletContext;
    }

    public WebContainerContext getWebContainerContext() {
        return this.webContainerContext;
    }

    public boolean is404() {
        return this.is404;
    }

    @Override
    public String getServletClass() {
        if (super.getServletClass() != null) {
            return super.getServletClass();
        }
        if (this.servletModel.getServletClass() != null) {
            return this.servletModel.getServletClass().getName();
        }
        if (this.servletModel.getServlet() != null) {
            return this.servletModel.getServlet().getClass().getName();
        }
        if (this.servletModel.getElementSupplier() != null) {
            return ((Servlet)this.servletModel.getElementSupplier().get()).getClass().getName();
        }
        return null;
    }

    @Override
    public synchronized Servlet loadServlet() throws ServletException {
        Servlet instance = super.getServlet();
        if (instance == null) {
            if (this.serviceReference != null) {
                BundleContext context = this.servletModel.getRegisteringBundle().getBundleContext();
                if (context != null) {
                    if (!this.servletModel.isPrototype()) {
                        instance = (Servlet)context.getService(this.serviceReference);
                    } else {
                        this.serviceObjects = context.getServiceObjects(this.serviceReference);
                        instance = (Servlet)this.serviceObjects.getService();
                    }
                }
            } else if (this.servletClass != null) {
                try {
                    instance = this.servletClass.newInstance();
                }
                catch (Exception e) {
                    throw new ServletException("Can't instantiate servlet with class " + this.servletClass + ": " + e.getMessage(), (Throwable)e);
                }
            } else if (this.servletModel != null && this.servletModel.getElementSupplier() != null) {
                instance = (Servlet)this.servletModel.getElementSupplier().get();
            }
        }
        if (instance != null && this.servletModel != null && this.servletModel.isResourceServlet()) {
            ((TomcatResourceServlet)instance).setWelcomeFiles(this.osgiServletContext.getWelcomeFiles());
            ((TomcatResourceServlet)instance).setWelcomeFilesRedirect(this.osgiServletContext.isWelcomeFilesRedirect());
        }
        if (instance == null && this.servletModel != null) {
            this.servletModel.setDtoFailureCode(5);
            throw new IllegalStateException("Can't load servlet for " + this.servletModel);
        }
        return new OsgiInitializedServlet(instance, this.servletContext, this.whiteboardTCCL);
    }

    @Override
    public synchronized void unload() throws ServletException {
        super.unload();
        if (this.servletModel != null && this.servletModel.getElementReference() != null) {
            BundleContext context = this.servletModel.getRegisteringBundle().getBundleContext();
            if (!this.servletModel.isPrototype() && context != null) {
                context.ungetService(this.servletModel.getElementReference());
            } else if (this.serviceObjects != null && this.getServlet() != null) {
                this.serviceObjects.ungetService((Object)this.getServlet());
            }
        }
        if (this.servletModel != null && this.servletModel.getRegisteringBundle() != null) {
            this.servletContext.releaseWebContainerContext(this.servletModel.getRegisteringBundle());
        }
    }

    public void setWhiteboardTCCL(boolean whiteboardTCCL) {
        this.whiteboardTCCL = whiteboardTCCL;
    }
}

