/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal.web;

import java.io.File;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.servlets.DefaultServlet;
import org.ops4j.pax.web.service.spi.config.ResourceConfiguration;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.util.Path;
import org.ops4j.pax.web.service.tomcat.internal.web.OsgiStandardRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatResourceServlet
extends DefaultServlet {
    public static final Logger LOG = LoggerFactory.getLogger(TomcatResourceServlet.class);
    private final File baseDirectory;
    private final String chroot;
    private final ResourceConfiguration resourceConfig;
    private String[] welcomeFiles;
    private boolean redirectWelcome = false;
    private boolean pathInfoOnly = true;

    public TomcatResourceServlet(File baseDirectory, String chroot, ResourceConfiguration resourceConfig) {
        this.baseDirectory = baseDirectory;
        this.chroot = chroot;
        this.resourceConfig = resourceConfig;
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
        if (this.resources != null) {
            this.resources.setCachingAllowed(false);
            this.resources.setCachingAllowed(true);
        }
    }

    public void setWelcomeFilesRedirect(boolean welcomeFilesRedirect) {
        this.redirectWelcome = welcomeFilesRedirect;
    }

    @Override
    public void init() throws ServletException {
        super.init();
        this.listings = false;
        this.readOnly = true;
        this.showServerInfo = false;
        this.redirectWelcome = "true".equalsIgnoreCase(this.getInitParameter("redirectWelcome"));
        this.pathInfoOnly = !"false".equalsIgnoreCase(this.getInitParameter("pathInfoOnly"));
        ServletContext osgiScopedServletContext = this.getServletContext();
        int maxEntrySize = this.resourceConfig == null || this.resourceConfig.maxCacheEntrySize() == null ? (int)this.resources.getCacheMaxSize() / 20 : this.resourceConfig.maxCacheEntrySize();
        this.resources = new OsgiStandardRoot(this.resources, this.baseDirectory, this.chroot, osgiScopedServletContext, maxEntrySize * 1024);
        this.resources.setCachingAllowed(true);
        this.resources.setCacheMaxSize(this.resourceConfig == null || this.resourceConfig.maxTotalCacheSize() == null ? 10240L : (long)this.resourceConfig.maxTotalCacheSize().intValue());
        this.resources.setCacheObjectMaxSize(maxEntrySize);
        this.resources.setCacheTtl(this.resourceConfig == null || this.resourceConfig.maxCacheTTL() == null ? 5000L : (long)this.resourceConfig.maxCacheTTL().intValue());
        LOG.info("Initialized Tomcat Resource Servlet for base=\"{}\" with cache maxSize={}kB, maxEntrySize={}kB, TTL={}ms", new Object[]{this.baseDirectory != null ? this.baseDirectory : this.chroot, this.resources.getCacheMaxSize(), this.resources.getCacheObjectMaxSize(), this.resources.getCacheTtl()});
        if (this.welcomeFiles == null) {
            if (osgiScopedServletContext instanceof OsgiScopedServletContext) {
                this.welcomeFiles = ((OsgiScopedServletContext)osgiScopedServletContext).getWelcomeFiles();
                this.redirectWelcome = ((OsgiScopedServletContext)osgiScopedServletContext).isWelcomeFilesRedirect();
            } else if (osgiScopedServletContext instanceof OsgiServletContext) {
                this.welcomeFiles = ((OsgiServletContext)osgiScopedServletContext).getWelcomeFiles();
                this.redirectWelcome = ((OsgiServletContext)osgiScopedServletContext).isWelcomeFilesRedirect();
            }
        }
        if (this.welcomeFiles == null) {
            this.welcomeFiles = new String[0];
        }
        try {
            this.resources.start();
        }
        catch (LifecycleException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content, String inputEncoding) throws IOException, ServletException {
        String relativePath;
        boolean included = false;
        String requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (requestURI == null) {
            requestURI = request.getRequestURI();
        } else {
            included = true;
        }
        if (requestURI == null || !requestURI.endsWith("/")) {
            super.serveResource(request, response, content, inputEncoding);
            return;
        }
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            String string = servletPath = !included ? request.getServletPath() : "";
        }
        if (servletPath.endsWith("/")) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        if ("".equals(relativePath = this.getRelativePath(request, true))) {
            relativePath = "/";
        }
        String resolvedWelcome = null;
        for (String welcome : this.welcomeFiles) {
            String path = relativePath + welcome;
            WebResource resource = this.resources.getResource(path);
            if (!resource.exists()) continue;
            resolvedWelcome = this.pathInfoOnly ? servletPath + path : path;
            break;
        }
        RequestDispatcher dispatcher = null;
        if (resolvedWelcome == null) {
            for (String welcome : this.welcomeFiles) {
                String path = servletPath + relativePath + welcome;
                dispatcher = request.getRequestDispatcher(path);
                if (dispatcher == null) continue;
                resolvedWelcome = path;
                break;
            }
        }
        if (resolvedWelcome != null) {
            if (this.redirectWelcome) {
                if (included) {
                    LOG.warn("Can't redirect to welcome page for INCLUDE dispatch");
                    return;
                }
                String queryString = request.getQueryString();
                if (queryString != null && !"".equals(queryString)) {
                    resolvedWelcome = resolvedWelcome + "?" + queryString;
                }
                resolvedWelcome = request.getContextPath() + resolvedWelcome;
                response.sendRedirect(response.encodeRedirectURL(resolvedWelcome));
            } else {
                if (dispatcher == null) {
                    dispatcher = request.getRequestDispatcher(resolvedWelcome);
                }
                if (included) {
                    dispatcher.include((ServletRequest)request, (ServletResponse)response);
                } else {
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
            }
            return;
        }
        WebResource resource = this.resources.getResource(relativePath);
        if (!resource.exists()) {
            if (request.getDispatcherType() == DispatcherType.ERROR) {
                response.sendError(((Integer)request.getAttribute("javax.servlet.error.status_code")).intValue());
            } else {
                response.sendError(404, requestURI);
            }
            return;
        }
        if (request.getDispatcherType() == DispatcherType.ERROR) {
            response.sendError(((Integer)request.getAttribute("javax.servlet.error.status_code")).intValue());
        } else {
            response.sendError(403, requestURI);
        }
    }

    @Override
    protected String getRelativePath(HttpServletRequest request, boolean allowEmptyPath) {
        String childPath;
        String pathInfo = request.getAttribute("javax.servlet.include.request_uri") != null ? (String)request.getAttribute("javax.servlet.include.path_info") : request.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "";
        }
        String servletPath = request.getAttribute("javax.servlet.include.servlet_path") != null ? (String)request.getAttribute("javax.servlet.include.servlet_path") : request.getServletPath();
        String pathInContext = pathInfo;
        if (!this.pathInfoOnly) {
            pathInContext = servletPath + pathInfo;
        }
        if ((childPath = Path.securePath((String)pathInContext)) == null) {
            return null;
        }
        if (childPath.length() > 0 && !childPath.startsWith("/")) {
            childPath = "/" + childPath;
        }
        return childPath;
    }
}

