/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.ActionSpec;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcFutureAware;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.RpcResultUtil;
import org.opendaylight.mdsal.binding.dom.adapter.StaticConfiguration;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

final class ActionAdapter
extends AbstractBindingAdapter<DOMActionService>
implements InvocationHandler {
    private final @NonNull ActionSpec<?, ?> spec;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier inputName;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute actionPath;

    ActionAdapter(AdapterContext codec, DOMActionService delegate, ActionSpec<?, ?> spec) {
        super(codec, delegate);
        this.spec = Objects.requireNonNull(spec);
        this.actionPath = this.currentSerializer().getActionPath(spec);
        this.inputName = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.operationInputQName((QNameModule)this.actionPath.lastNodeIdentifier().getModule()));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "equals": {
                if (args.length != 1) break;
                return proxy == args[0];
            }
            case "hashCode": {
                if (args.length != 0) break;
                return System.identityHashCode(proxy);
            }
            case "toString": {
                if (args.length != 0) break;
                return this.spec.type().getName() + "$Adapter{delegate=" + this.getDelegate() + "}";
            }
            case "invoke": {
                if (args.length != 2) break;
                InstanceIdentifier path = (InstanceIdentifier)Objects.requireNonNull(args[0]);
                Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Cannot invoke action on wildcard path %s", (Object)path);
                RpcInput input = (RpcInput)Objects.requireNonNull(args[1]);
                CurrentAdapterSerializer serializer = this.currentSerializer();
                ListenableFuture future = ((DOMActionService)this.getDelegate()).invokeAction(this.actionPath, new DOMDataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, serializer.toYangInstanceIdentifier(path)), (ContainerNode)serializer.toLazyNormalizedNodeActionInput(this.spec.type(), this.inputName, input));
                if (StaticConfiguration.ENABLE_CODEC_SHORTCUT && future instanceof BindingRpcFutureAware) {
                    BindingRpcFutureAware bindingAware = (BindingRpcFutureAware)future;
                    return bindingAware.getBindingFuture();
                }
                return Futures.transform((ListenableFuture)future, dom -> RpcResultUtil.rpcResultFromDOM(dom.getErrors(), dom.getOutput().map(output -> serializer.fromNormalizedNodeActionOutput(this.spec.type(), (ContainerNode)output)).orElse(null)), (Executor)MoreExecutors.directExecutor());
            }
        }
        if (method.isDefault()) {
            return InvocationHandler.invokeDefault(proxy, method, args);
        }
        throw new NoSuchMethodError("Method " + method.toString() + "is unsupported.");
    }
}

