/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.Transaction;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.TransactionChainClosedException;
import org.opendaylight.mdsal.binding.api.TransactionChainListener;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMReadTransactionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMReadWriteTransactionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMWriteTransactionAdapter;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainClosedException;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.yangtools.concepts.Delegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BindingDOMTransactionChainAdapter
implements TransactionChain,
Delegator<DOMTransactionChain> {
    private static final Logger LOG = LoggerFactory.getLogger(BindingDOMTransactionChainAdapter.class);
    private final DOMTransactionChain delegate;
    private final AdapterContext adapterContext;
    private final DelegateChainListener domListener;
    private final TransactionChainListener bindingListener;

    BindingDOMTransactionChainAdapter(Function<DOMTransactionChainListener, DOMTransactionChain> chainFactory, AdapterContext codec, TransactionChainListener listener) {
        Objects.requireNonNull(chainFactory, "DOM Transaction chain factory must not be null");
        this.domListener = new DelegateChainListener();
        this.bindingListener = listener;
        this.delegate = chainFactory.apply(this.domListener);
        this.adapterContext = Objects.requireNonNull(codec);
    }

    public DOMTransactionChain getDelegate() {
        return this.delegate;
    }

    public ReadTransaction newReadOnlyTransaction() {
        return new BindingDOMReadTransactionAdapter(this.adapterContext, BindingDOMTransactionChainAdapter.createTransaction(() -> ((DOMTransactionChain)this.delegate).newReadOnlyTransaction()));
    }

    public WriteTransaction newWriteOnlyTransaction() {
        DOMDataTreeWriteTransaction delegateTx = BindingDOMTransactionChainAdapter.createTransaction(() -> ((DOMTransactionChain)this.delegate).newWriteOnlyTransaction());
        return new BindingDOMWriteTransactionAdapter<DOMDataTreeWriteTransaction>(this.adapterContext, delegateTx){

            @Override
            public FluentFuture<? extends CommitInfo> commit() {
                return BindingDOMTransactionChainAdapter.this.listenForFailure(this, super.commit());
            }
        };
    }

    public ReadWriteTransaction newReadWriteTransaction() {
        DOMDataTreeReadWriteTransaction delegateTx = BindingDOMTransactionChainAdapter.createTransaction(() -> ((DOMTransactionChain)this.delegate).newReadWriteTransaction());
        return new BindingDOMReadWriteTransactionAdapter(this.adapterContext, delegateTx){

            @Override
            public FluentFuture<? extends CommitInfo> commit() {
                return BindingDOMTransactionChainAdapter.this.listenForFailure(this, super.commit());
            }
        };
    }

    private <T, F extends ListenableFuture<T>> F listenForFailure(final WriteTransaction tx, F future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onFailure(Throwable throwable) {
                BindingDOMTransactionChainAdapter.this.failTransactionChain(tx, throwable);
            }

            public void onSuccess(T result) {
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    private void failTransactionChain(WriteTransaction tx, Throwable throwable) {
        this.bindingListener.onTransactionChainFailed((TransactionChain)this, (Transaction)tx, throwable);
    }

    public void close() {
        this.delegate.close();
    }

    private static <T> T createTransaction(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (DOMTransactionChainClosedException e) {
            throw new TransactionChainClosedException("Transaction chain already closed", (Throwable)e);
        }
    }

    private final class DelegateChainListener
    implements DOMTransactionChainListener {
        private DelegateChainListener() {
        }

        public void onTransactionChainFailed(DOMTransactionChain chain, DOMDataTreeTransaction transaction, Throwable cause) {
            Preconditions.checkState((boolean)BindingDOMTransactionChainAdapter.this.delegate.equals(chain), (String)"Listener for %s was invoked for incorrect chain %s.", (Object)BindingDOMTransactionChainAdapter.this.delegate, (Object)chain);
            LOG.debug("Transaction chain {} failed. Failed DOM Transaction {}", new Object[]{this, transaction, cause});
        }

        public void onTransactionChainSuccessful(DOMTransactionChain chain) {
            Preconditions.checkState((boolean)BindingDOMTransactionChainAdapter.this.delegate.equals(chain), (String)"Listener for %s was invoked for incorrect chain %s.", (Object)BindingDOMTransactionChainAdapter.this.delegate, (Object)chain);
            BindingDOMTransactionChainAdapter.this.bindingListener.onTransactionChainSuccessful((TransactionChain)BindingDOMTransactionChainAdapter.this);
        }
    }
}

