/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.InstanceNotificationPublishService;
import org.opendaylight.mdsal.binding.api.InstanceNotificationSpec;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazySerializedInstanceNotification;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMInstanceNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.InstanceNotification;

final class PublisherAdapter<N extends InstanceNotification<N, P>, P extends DataObject>
extends AbstractBindingAdapter<DOMInstanceNotificationPublishService>
implements InstanceNotificationPublishService.Publisher<N, P> {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute notificationPath;

    PublisherAdapter(AdapterContext adapterContext, DOMInstanceNotificationPublishService domPublishService, InstanceNotificationSpec<?, ?> spec) {
        super(adapterContext, domPublishService);
        this.notificationPath = this.currentSerializer().getNotificationPath(spec);
    }

    public void putNotification(InstanceIdentifier<P> path, N notification) throws InterruptedException {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        ((DOMInstanceNotificationPublishService)this.getDelegate()).putNotification(PublisherAdapter.toDomPath(serializer, path), this.toDomNotification(serializer, (InstanceNotification<?, ?>)notification));
    }

    public ListenableFuture<? extends Object> offerNotification(InstanceIdentifier<P> path, N notification) {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        return PublisherAdapter.toBindingResult((ListenableFuture<? extends Object>)((DOMInstanceNotificationPublishService)this.getDelegate()).offerNotification(PublisherAdapter.toDomPath(serializer, path), this.toDomNotification(serializer, (InstanceNotification<?, ?>)notification)));
    }

    public ListenableFuture<? extends Object> offerNotification(InstanceIdentifier<P> path, N notification, long timeout, TimeUnit unit) throws InterruptedException {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        return PublisherAdapter.toBindingResult((ListenableFuture<? extends Object>)((DOMInstanceNotificationPublishService)this.getDelegate()).offerNotification(PublisherAdapter.toDomPath(serializer, path), this.toDomNotification(serializer, (InstanceNotification<?, ?>)notification), timeout, unit));
    }

    private static @NonNull ListenableFuture<? extends Object> toBindingResult(@NonNull ListenableFuture<? extends Object> domResult) {
        return DOMInstanceNotificationPublishService.REJECTED.equals(domResult) ? REJECTED : domResult;
    }

    private static @NonNull DOMDataTreeIdentifier toDomPath(CurrentAdapterSerializer serializer, InstanceIdentifier<?> path) {
        return new DOMDataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, serializer.toYangInstanceIdentifier(path));
    }

    private @NonNull DOMNotification toDomNotification(CurrentAdapterSerializer serializer, InstanceNotification<?, ?> notification) {
        return new LazySerializedInstanceNotification((BindingNormalizedNodeSerializer)serializer, this.notificationPath, notification);
    }
}

