/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.FutureVersionException;
import org.opendaylight.controller.cluster.access.PastVersionException;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ABIVersion implements WritableObject
{
    TEST_PAST_VERSION(0){

        @Override
        public NormalizedNodeStreamVersion getStreamVersion() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    MAGNESIUM(8){

        @Override
        public NormalizedNodeStreamVersion getStreamVersion() {
            return NormalizedNodeStreamVersion.MAGNESIUM;
        }
    }
    ,
    CHLORINE_SR2(9){

        @Override
        public NormalizedNodeStreamVersion getStreamVersion() {
            return NormalizedNodeStreamVersion.MAGNESIUM;
        }
    }
    ,
    TEST_FUTURE_VERSION(65535){

        @Override
        public NormalizedNodeStreamVersion getStreamVersion() {
            throw new UnsupportedOperationException();
        }
    };

    private static final Logger LOG;
    private final short value;

    private ABIVersion(int intVersion) {
        Preconditions.checkArgument((intVersion >= 0 && intVersion <= 65535 ? 1 : 0) != 0);
        this.value = (short)intVersion;
    }

    public short shortValue() {
        return this.value;
    }

    public static @NonNull ABIVersion current() {
        return CHLORINE_SR2;
    }

    public static @NonNull ABIVersion valueOf(short value) throws FutureVersionException, PastVersionException {
        return switch (Short.toUnsignedInt(value)) {
            case 0, 1, 2, 3, 4, 6, 7 -> throw new PastVersionException(value, MAGNESIUM);
            case 8 -> MAGNESIUM;
            case 9 -> CHLORINE_SR2;
            default -> throw new FutureVersionException(value, CHLORINE_SR2);
        };
    }

    public boolean lt(@NonNull ABIVersion other) {
        return this.compareTo(other) < 0;
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeShort(this.value);
    }

    public abstract @NonNull NormalizedNodeStreamVersion getStreamVersion();

    public static @NonNull ABIVersion readFrom(@NonNull DataInput in) throws IOException {
        short s = in.readShort();
        try {
            return ABIVersion.valueOf(s);
        }
        catch (FutureVersionException | PastVersionException e) {
            throw new IOException("Unsupported version", e);
        }
    }

    public static @NonNull ABIVersion inexactReadFrom(@NonNull DataInput in) throws IOException {
        short onWire = in.readShort();
        try {
            return ABIVersion.valueOf(onWire);
        }
        catch (FutureVersionException e) {
            LOG.debug("Received future version", (Throwable)e);
            return TEST_FUTURE_VERSION;
        }
        catch (PastVersionException e) {
            LOG.debug("Received past version", (Throwable)e);
            return TEST_PAST_VERSION;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ABIVersion.class);
    }
}

