/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.FI;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

public final class FrontendIdentifier
implements WritableIdentifier {
    private static final long serialVersionUID = 1L;
    private final MemberName memberName;
    private final FrontendType clientType;

    FrontendIdentifier(MemberName memberName, FrontendType clientType) {
        this.clientType = Objects.requireNonNull(clientType);
        this.memberName = Objects.requireNonNull(memberName);
    }

    public static @NonNull FrontendIdentifier create(MemberName memberName, FrontendType clientType) {
        return new FrontendIdentifier(memberName, clientType);
    }

    public static @NonNull FrontendIdentifier readFrom(DataInput in) throws IOException {
        MemberName memberName = MemberName.readFrom(in);
        FrontendType clientType = FrontendType.readFrom(in);
        return new FrontendIdentifier(memberName, clientType);
    }

    public void writeTo(DataOutput out) throws IOException {
        this.memberName.writeTo(out);
        this.clientType.writeTo(out);
    }

    public @NonNull FrontendType getClientType() {
        return this.clientType;
    }

    public @NonNull MemberName getMemberName() {
        return this.memberName;
    }

    public int hashCode() {
        return Objects.hash(this.memberName, this.clientType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FrontendIdentifier)) return false;
        FrontendIdentifier other = (FrontendIdentifier)obj;
        if (!this.memberName.equals(other.memberName)) return false;
        if (!this.clientType.equals(other.clientType)) return false;
        return true;
    }

    public @NonNull String toPersistentId() {
        return this.memberName.getName() + "-frontend-" + this.clientType.getName();
    }

    public String toString() {
        return this.toPersistentId();
    }

    private Object writeReplace() {
        return new FI(this);
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Proxy
    implements SerialForm {
        private static final long serialVersionUID = 1L;
        private FrontendIdentifier identifier;

        public Proxy() {
        }

        Proxy(FrontendIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier);
        }

        @Override
        public FrontendIdentifier identifier() {
            return (FrontendIdentifier)Verify.verifyNotNull((Object)this.identifier);
        }

        @Override
        public void setIdentifier(FrontendIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier);
        }

        @Override
        public Object readResolve() {
            return this.identifier();
        }
    }

    static interface SerialForm
    extends Externalizable {
        public @NonNull FrontendIdentifier identifier();

        public void setIdentifier(@NonNull FrontendIdentifier var1);

        public Object readResolve();

        @Override
        default public void writeExternal(ObjectOutput out) throws IOException {
            FrontendIdentifier id = this.identifier();
            id.memberName.writeTo(out);
            id.clientType.writeTo(out);
        }

        @Override
        default public void readExternal(ObjectInput in) throws IOException {
            this.setIdentifier(new FrontendIdentifier(MemberName.readFrom(in), FrontendType.readFrom(in)));
        }
    }
}

