/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.broker.TransactionCommitFailedExceptionMapper;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class CommitCoordinationTask
implements Callable<CommitInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(CommitCoordinationTask.class);
    private final DOMStoreThreePhaseCommitCohort cohort;
    private final DOMDataTreeWriteTransaction tx;

    CommitCoordinationTask(DOMDataTreeWriteTransaction transaction, DOMStoreThreePhaseCommitCohort cohort) {
        this.tx = Objects.requireNonNull(transaction, "transaction must not be null");
        this.cohort = Objects.requireNonNull(cohort, "cohort must not be null");
    }

    @Override
    public CommitInfo call() throws TransactionCommitFailedException {
        Phase phase = Phase.CAN_COMMIT;
        try {
            LOG.debug("Transaction {}: canCommit Started", this.tx.getIdentifier());
            this.canCommitBlocking();
            phase = Phase.PRE_COMMIT;
            LOG.debug("Transaction {}: preCommit Started", this.tx.getIdentifier());
            this.preCommitBlocking();
            phase = Phase.DO_COMMIT;
            LOG.debug("Transaction {}: doCommit Started", this.tx.getIdentifier());
            this.commitBlocking();
            LOG.debug("Transaction {}: doCommit completed", this.tx.getIdentifier());
            return CommitInfo.empty();
        }
        catch (TransactionCommitFailedException e) {
            LOG.warn("Tx: {} Error during phase {}, starting Abort", new Object[]{this.tx.getIdentifier(), phase, e});
            this.abortBlocking(e);
            throw e;
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
    private void canCommitBlocking() throws TransactionCommitFailedException {
        Boolean result;
        ListenableFuture future = this.cohort.canCommit();
        try {
            result = (Boolean)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw (TransactionCommitFailedException)((Object)TransactionCommitFailedExceptionMapper.CAN_COMMIT_ERROR_MAPPER.apply(e));
        }
        if (!Boolean.TRUE.equals(result)) {
            throw new TransactionCommitFailedException("Can Commit failed, no detailed cause available.", new RpcError[0]);
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
    private void preCommitBlocking() throws TransactionCommitFailedException {
        try {
            this.cohort.preCommit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw (TransactionCommitFailedException)((Object)TransactionCommitFailedExceptionMapper.PRE_COMMIT_MAPPER.apply(e));
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
    private void commitBlocking() throws TransactionCommitFailedException {
        try {
            this.cohort.commit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw (TransactionCommitFailedException)((Object)TransactionCommitFailedExceptionMapper.COMMIT_ERROR_MAPPER.apply(e));
        }
    }

    private void abortBlocking(TransactionCommitFailedException originalCause) throws TransactionCommitFailedException {
        Throwable cause = originalCause;
        try {
            this.cohort.abort().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Tx: {} Error during Abort.", this.tx.getIdentifier(), (Object)e);
            cause = new IllegalStateException("Abort failed.", e);
            cause.addSuppressed(e);
        }
        Throwables.propagateIfPossible((Throwable)cause, TransactionCommitFailedException.class);
    }

    private static enum Phase {
        CAN_COMMIT,
        PRE_COMMIT,
        DO_COMMIT;

    }

    static final class WithTracker
    extends CommitCoordinationTask {
        private final DurationStatisticsTracker commitStatTracker;

        WithTracker(DOMDataTreeWriteTransaction transaction, DOMStoreThreePhaseCommitCohort cohort, DurationStatisticsTracker commitStatTracker) {
            super(transaction, cohort);
            this.commitStatTracker = Objects.requireNonNull(commitStatTracker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CommitInfo call() throws TransactionCommitFailedException {
            long startTime = System.nanoTime();
            try {
                CommitInfo commitInfo = super.call();
                return commitInfo;
            }
            finally {
                this.commitStatTracker.addDuration(System.nanoTime() - startTime);
            }
        }
    }
}

