/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.codec.UnionCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UnionStringCodec
extends TypeDefinitionAwareCodec<Object, UnionTypeDefinition>
implements UnionCodec<String> {
    private static final Logger LOG = LoggerFactory.getLogger(UnionStringCodec.class);
    private final ImmutableList<TypeDefinitionAwareCodec<Object, ?>> codecs;

    private UnionStringCodec(UnionTypeDefinition typeDef, ImmutableList<TypeDefinitionAwareCodec<Object, ?>> codecs) {
        super(Objects.requireNonNull(typeDef), Object.class);
        this.codecs = Objects.requireNonNull(codecs);
    }

    static @Nullable TypeDefinitionAwareCodec<?, UnionTypeDefinition> from(UnionTypeDefinition typeDef) {
        List types = typeDef.getTypes();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)types.size());
        for (TypeDefinition type : types) {
            TypeDefinitionAwareCodec<Object, ?> codec = UnionStringCodec.from(type);
            if (codec == null) {
                LOG.debug("Cannot handle {} because of unhandled component {}", (Object)typeDef, (Object)type);
                return null;
            }
            builder.add(codec);
        }
        return new UnionStringCodec(typeDef, builder.build());
    }

    protected Object deserializeImpl(String stringRepresentation) {
        ArrayList<IllegalArgumentException> suppressed = null;
        for (TypeDefinitionAwareCodec codec : this.codecs) {
            try {
                return codec.deserialize(stringRepresentation);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Value {} did not match codec {}", new Object[]{stringRepresentation, codec, e});
                if (suppressed == null) {
                    suppressed = new ArrayList<IllegalArgumentException>();
                }
                suppressed.add(e);
            }
        }
        IllegalArgumentException ex = new IllegalArgumentException("Invalid value \"" + stringRepresentation + "\" for union type.");
        if (suppressed != null) {
            suppressed.forEach(ex::addSuppressed);
        }
        throw ex;
    }

    protected String serializeImpl(Object data) {
        return data instanceof byte[] ? Base64.getEncoder().encodeToString((byte[])data) : data.toString();
    }
}

