/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableMetadataNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.InterningLeafNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.InterningLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeMetadataResult;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResultBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableAugmentationNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUnkeyedListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUserLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUserMapNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

public class ImmutableNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter {
    private final Deque<NormalizedNodeBuilder> builders = new ArrayDeque<NormalizedNodeBuilder>();
    private DataSchemaNode nextSchema;

    protected ImmutableNormalizedNodeStreamWriter(NormalizedNodeBuilder topLevelBuilder) {
        this.builders.push(topLevelBuilder);
    }

    protected ImmutableNormalizedNodeStreamWriter(NormalizedNodeResult result) {
        this((NormalizedNodeBuilder)new NormalizedNodeResultBuilder(result));
    }

    public static @NonNull NormalizedNodeStreamWriter from(NormalizedNodeContainerBuilder<?, ?, ?, ?> builder) {
        return new ImmutableNormalizedNodeStreamWriter((NormalizedNodeBuilder)builder);
    }

    public static @NonNull NormalizedNodeStreamWriter from(NormalizedNodeResult result) {
        return result instanceof NormalizedNodeMetadataResult ? ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeMetadataResult)result) : new ImmutableNormalizedNodeStreamWriter(result);
    }

    public static @NonNull NormalizedNodeStreamWriter from(NormalizedNodeMetadataResult result) {
        return new ImmutableMetadataNormalizedNodeStreamWriter(result);
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, this.leafNodeBuilder(this.nextSchema));
        this.nextSchema = null;
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? InterningLeafSetNodeBuilder.create(this.nextSchema) : InterningLeafSetNodeBuilder.create(this.nextSchema, childSizeHint)));
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) {
        NormalizedNodeBuilder current = this.current();
        Preconditions.checkArgument((current instanceof ImmutableLeafSetNodeBuilder || current instanceof ImmutableUserLeafSetNodeBuilder || current instanceof NormalizedNodeResultBuilder ? 1 : 0) != 0, (String)"LeafSetEntryNode is not valid for parent %s", (Object)current);
        this.enter((YangInstanceIdentifier.PathArgument)name, this.leafsetEntryNodeBuilder());
        this.nextSchema = null;
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)Builders.orderedLeafSetBuilder());
    }

    public boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) {
        this.checkDataNodeContainer();
        if (DOMSource.class.isAssignableFrom(objectModel)) {
            this.enter((YangInstanceIdentifier.PathArgument)name, Builders.anyXmlBuilder());
            this.nextSchema = null;
            return true;
        }
        return false;
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? Builders.containerBuilder() : Builders.containerBuilder(childSizeHint)));
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? Builders.unkeyedListBuilder() : Builders.unkeyedListBuilder(childSizeHint)));
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        NormalizedNodeBuilder current = this.current();
        Preconditions.checkArgument((current instanceof ImmutableUnkeyedListNodeBuilder || current instanceof NormalizedNodeResultBuilder ? 1 : 0) != 0);
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? Builders.unkeyedListEntryBuilder() : Builders.unkeyedListEntryBuilder(childSizeHint)));
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? Builders.mapBuilder() : Builders.mapBuilder(childSizeHint)));
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) {
        NormalizedNodeBuilder current = this.current();
        Preconditions.checkArgument((current instanceof ImmutableMapNodeBuilder || current instanceof ImmutableUserMapNodeBuilder || current instanceof NormalizedNodeResultBuilder ? 1 : 0) != 0);
        this.enter((YangInstanceIdentifier.PathArgument)identifier, (NormalizedNodeBuilder)(-1 == childSizeHint ? Builders.mapEntryBuilder() : Builders.mapEntryBuilder(childSizeHint)));
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? Builders.orderedMapBuilder() : Builders.orderedMapBuilder(childSizeHint)));
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? Builders.choiceBuilder() : Builders.choiceBuilder(childSizeHint)));
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        this.checkDataNodeContainer();
        Preconditions.checkArgument((!(this.current() instanceof ImmutableAugmentationNodeBuilder) ? 1 : 0) != 0);
        this.enter((YangInstanceIdentifier.PathArgument)identifier, (NormalizedNodeBuilder)Builders.augmentationBuilder());
    }

    public void flush() {
    }

    public void close() {
    }

    public void nextDataSchemaNode(DataSchemaNode schema) {
        this.nextSchema = Objects.requireNonNull(schema);
    }

    public void scalarValue(Object value) {
        this.currentScalar().withValue(value);
    }

    public void domSourceValue(DOMSource value) {
        this.currentScalar().withValue((Object)value);
    }

    public void endNode() {
        NormalizedNodeBuilder finishedBuilder = this.builders.poll();
        Preconditions.checkState((finishedBuilder != null ? 1 : 0) != 0, (Object)"Node which should be closed does not exists.");
        NormalizedNode product = finishedBuilder.build();
        this.nextSchema = null;
        this.writeChild(product);
    }

    public boolean startAnydataNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, Builders.anydataBuilder(objectModel));
        return true;
    }

    protected final void writeChild(NormalizedNode child) {
        NormalizedNodeContainerBuilder current = this.currentContainer();
        Preconditions.checkState((current != null ? 1 : 0) != 0, (Object)"Reached top level node, which could not be closed in this writer.");
        current.addChild(Objects.requireNonNull(child));
    }

    void enter(YangInstanceIdentifier.PathArgument identifier, NormalizedNodeBuilder next) {
        this.builders.push(next.withNodeIdentifier(identifier));
        this.nextSchema = null;
    }

    protected final NormalizedNodeBuilder popBuilder() {
        return this.builders.pop();
    }

    final void reset(NormalizedNodeResultBuilder builder) {
        this.nextSchema = null;
        this.builders.clear();
        this.builders.push((NormalizedNodeBuilder)builder);
    }

    private <T> ImmutableLeafNodeBuilder<T> leafNodeBuilder(DataSchemaNode schema) {
        InterningLeafNodeBuilder interning = InterningLeafNodeBuilder.forSchema(schema);
        return interning != null ? interning : this.leafNodeBuilder();
    }

    <T> ImmutableLeafNodeBuilder<T> leafNodeBuilder() {
        return new ImmutableLeafNodeBuilder();
    }

    <T> ImmutableLeafSetEntryNodeBuilder<T> leafsetEntryNodeBuilder() {
        return ImmutableLeafSetEntryNodeBuilder.create();
    }

    private void checkDataNodeContainer() {
        NormalizedNodeContainerBuilder current = this.currentContainer();
        if (!(current instanceof NormalizedNodeResultBuilder)) {
            Preconditions.checkArgument((boolean)(current instanceof DataContainerNodeBuilder), (Object)"Invalid nesting of data.");
        }
    }

    private NormalizedNodeBuilder current() {
        return this.builders.peek();
    }

    private NormalizedNodeContainerBuilder currentContainer() {
        NormalizedNodeBuilder current = this.current();
        if (current == null) {
            return null;
        }
        Preconditions.checkState((boolean)(current instanceof NormalizedNodeContainerBuilder), (String)"%s is not a node container", (Object)current);
        return (NormalizedNodeContainerBuilder)current;
    }

    private NormalizedNodeBuilder currentScalar() {
        NormalizedNodeBuilder current = this.current();
        Preconditions.checkState((!(current instanceof NormalizedNodeContainerBuilder) ? 1 : 0) != 0, (String)"Unexpected node container %s", (Object)current);
        return current;
    }
}

